 proc(2) = h_cov_ha_frac(d,psi,param,nsim,rmatrix_string);
 
 /* Generate nsim HA covariance matrices for h-test for long-memory with 
    stationary parameter d;
    
    Program aslo returns covariance matrix for integrated long-memory process
    (long-memory with parameter 1+d)
    
    
    Input
         d = stationary long-memory parameter 
         psi = dct transformation 
         param = local parameter 
         nsim = number of simulations
         rmatrix_string = name of matrix with standard random variables ... on disk ... w draws
    
    Output
         cov_ha = vectorized version of cov_ha 
         cov_ha_sum = vectorized version of cov_ha for summed process
 
 */
 
 local missvalue,t,q,qq,qq_1,w,sdpath_mat,i,sum_mat,acv,gamd,gam_md,fac,t1,h,ghd,ghmd;
 local pow,cov_vech,cov_all,var,xma,jd,x,cov_insample,cov_presample,cov_psi_presample;
 local v_presample,psi_x,cov_ha,tmp,sx,cov_ha_sum;
 
 missvalue=miss(0,0);
  
 @ Check Values of d @
 if d .< -0.5;
  "This value of d is not allowed: d = ";;d;
  retp(missvalue,missvalue);
 endif;
 if d .> 0.5;
  "This value of d is not allowed: d = ";;d;
  retp(missvalue,missvalue);
 endif; 
  
 t=rows(psi);   @ t sample size @
 q=cols(psi);   @ number of ordinates @
 qq=q*(q+1)/2;
 
 @ Get draws of variance function @
 load w=^rmatrix_string;
 w=cumsumc(w[1:t,1:nsim])/sqrt(t);   @ Random Walk @
 w=(param/sqrt(q))*w;        @ Scaled @
 sdpath_mat=exp(w);          @ h path @
 
 @ Eliminate a few numerical problems at -0.5, 0.5, and 0.0 @
 if abs(d-.5) .< .00001;
   d=0.49999;
 endif;
 if abs(d+0.5) .< .00001;
   d=-0.49999;
 endif;
 if abs(d) .< .00001;
   d=.00001;
 endif;

 @ Construct summation matrix @
  sum_mat=zeros(t,t);
  for i (1,t,1);
    sum_mat[i,1:i]=ones(1,i);
  endfor;

 @ Total Covariance matrix @
 cov_all=frac_cov(t,d);
  
 @ Compute MA Representations @
 xma=miss(zeros(t,1),0);
 if d .>= 0;
  gamd=gamma(d);
 else;
  gamd=gamma(1+d)/d;
 endif;
 xma[1]=1;
 for j (1,100,1);
  i=j+1;
  jd=j+d;
  xma[i]=gamma(jd)/(gamd*gamma(i));
 endfor;
 for j (101,t-1,1);
  i=j+1;
  xma[i]=(j^(d-1))/gamd;
 endfor;
 
 @ Construct MA Matrix @
 x=zeros(t,t);
 for i (1,t,1);
  x[i:t,i]=xma[1:t+1-i];
 endfor;

 cov_insample=x*x'; 
 cov_presample=cov_all-cov_insample;
 
 cov_psi_presample=psi'cov_presample*psi;
 v_presample=vech(cov_psi_presample);         @ Presample Covariance Matrix @
 
 psi_x=psi'x;
 cov_ha=miss(zeros(qq,nsim),0);
 for i (1,nsim,1);
  tmp=psi_x.*sdpath_mat[.,i]';
  tmp=tmp*tmp';
  cov_ha[.,i]=vech(tmp)+v_presample;
 endfor;
 
 @ -- Summed Covariance Matrix -- @
 cov_presample=sum_mat*cov_presample*sum_mat';
 cov_psi_presample=psi'cov_presample*psi;
 v_presample=vech(cov_psi_presample);         @ Presample Covariance Matrix @
 
 sx=sum_mat*x;                     @ MA Rep for integrated process @
 psi_x=psi'sx;
 cov_ha_sum=miss(zeros(qq,nsim),0);
 for i (1,nsim,1);
  tmp=psi_x.*sdpath_mat[.,i]';
  tmp=tmp*tmp';
  cov_ha_sum[.,i]=vech(tmp)+v_presample;
 endfor;

retp(cov_ha,cov_ha_sum);
endp;
