 proc(3) = h_cov_ha_i0_i1_i2_2s(psi,param,nsim,rmatrix_string);
 
 /* Generate nsim HA covariance matrices for h-test for 
    (1) I(0) model
    (2) RW Model
    (3) Integrated RW model
    
    Use Random walk and -RandomWalk for Symmetry ... reduces variability
    
    Three covariance matrices are returned
    These are the ingredients to the covariance matrices for the local level and integrated local level models

    Input
         psi = dct transformation 
         param = local parameter 
         nsim = number of simulations
         rmatrix_string = name of matrix with standard random variables ... on disk ... w draws
    
    Output
         cov_ha_i0 = vectorized version of cov_ha 
         cov_ha_i1 = vectorized version of cov_ha for summed process
         cov_ha_i2 = vectorized version of cov_ha for double summed process
 
 */
 local t,q,qq,w,i,sdpath_mat,sum_mat,sum_mat2,cov_ha_i0,cov_ha_i1,cov_ha_i2,psi_0,psi_1,psi_2,tmp;
   
 t=rows(psi);   @ t sample size @
 q=cols(psi);   @ number of ordinates @
 qq=q*(q+1)/2;
 
 @ Get draws of variance function @
 load w=^rmatrix_string;
 w=cumsumc(w[1:t,1:nsim])/sqrt(t);   @ Random Walk @
 w=w~(-w);
 w=(param/sqrt(q))*w;        @ Scaled @
 sdpath_mat=exp(w);          @ h path @
 
  @ Construct summation matrix @
  sum_mat=zeros(t,t);
  for i (1,t,1);
    sum_mat[i,1:i]=ones(1,i);
  endfor;
  sum_mat2=sum_mat*sum_mat;         @ Double integration @

  cov_ha_i0=miss(zeros(qq,nsim),0);
  cov_ha_i1=cov_ha_i0;
  cov_ha_i2=cov_ha_i0;
  psi_0=psi';
  psi_1=psi'sum_mat;
  psi_2=psi'sum_mat2;
  
  for i (1,nsim,1);
   tmp=psi_0.*sdpath_mat[.,i]';
   tmp=tmp*tmp';
   cov_ha_i0[.,i]=vech(tmp);
   tmp=psi_1.*sdpath_mat[.,i]';
   tmp=tmp*tmp';
   cov_ha_i1[.,i]=vech(tmp);
   tmp=psi_2.*sdpath_mat[.,i]';
   tmp=tmp*tmp';
   cov_ha_i2[.,i]=vech(tmp); 
  endfor;
 retp(cov_ha_i0,cov_ha_i1,cov_ha_i2); 
endp;