 proc(2) = h_cov_ha_ou(c,psi,param,nsim,rmatrix_string);
 
 /* Generate nsim HA covariance matrices for h-test for local-level model with 
    parameter c
    
    Program aslo returns covariance matrix for integrated long-memory process
    (long-memory with parameter 1+d)
    
    
    Input
         c = diffusion parameter 
         psi = dct transformation 
         param = local parameter 
         nsim = number of simulations
         rmatrix_string = name of matrix with standard random variables ... on disk ... w draws
    
    Output
         cov_ha = vectorized version of cov_ha 
         cov_ha_sum = vectorized version of cov_ha for summed process
 
 */
 
 local t,q,qq,w,sdpath_mat,sum_mat,i,rho,rvec,x,cov,j,scale,cov_all,cov_insample,cov_presample;
 local cov_psi_presample,v_presample,psi_x,cov_ha,cov_ha_sum,tmp,sx;
  
 t=rows(psi);   @ t sample size @
 q=cols(psi);   @ number of ordinates @
 qq=q*(q+1)/2;
 
 @ Get draws of variance function @
 load w=^rmatrix_string;
 w=cumsumc(w[1:t,1:nsim])/sqrt(t);   @ Random Walk @
 w=(param/sqrt(q))*w;        @ Scaled @
 sdpath_mat=exp(w);          @ h path @
 
  @ Construct summation matrix @
  sum_mat=zeros(t,t);
  for i (1,t,1);
    sum_mat[i,1:i]=ones(1,i);
  endfor;

 rho=1-c/t;
 rvec=seqm(1,rho,t);
 x=zeros(t,t);
 x[.,1]=rvec;
 for i (2,t,1);
  x[i:t,i]=rvec[1:t+1-i];    @ MA Coefficients @
 endfor;
 
 if rho .>= 1;
  cov=x*x';
 else;
  cov=eye(t);            
  for i (1,t-1,1);
   for j (i+1,t,1);
    cov[i,j]=rho^(j-i);
    cov[j,i]=cov[i,j];
   endfor;
  endfor;
  scale=1/(1-rho*rho);
  cov=scale*cov;
 endif;
 cov_all=cov;
 cov_insample=x*x'; 
 cov_presample=cov_all-cov_insample;
 
 cov_psi_presample=psi'cov_presample*psi;
 v_presample=vech(cov_psi_presample);         @ Presample Covariance Matrix @
 
 psi_x=psi'x;
 cov_ha=miss(zeros(qq,nsim),0);
 for i (1,nsim,1);
  tmp=psi_x.*sdpath_mat[.,i]';
  tmp=tmp*tmp';
  cov_ha[.,i]=vech(tmp)+v_presample;
 endfor;
 
 @ -- Summed Covariance Matrix -- @
 cov_presample=sum_mat*cov_presample*sum_mat';
 cov_psi_presample=psi'cov_presample*psi;
 v_presample=vech(cov_psi_presample);         @ Presample Covariance Matrix @
 
 sx=sum_mat*x;                     @ MA Rep for integrated process @
 psi_x=psi'sx;
 cov_ha_sum=miss(zeros(qq,nsim),0);
 for i (1,nsim,1);
  tmp=psi_x.*sdpath_mat[.,i]';
  tmp=tmp*tmp';
  cov_ha_sum[.,i]=vech(tmp)+v_presample;
 endfor;

retp(cov_ha,cov_ha_sum);
endp;