@ ------------------------------------------------------------------ @
proc(1) = htest_i0_i1_pv(x_t,param,itrend,ind_int,n_wsim,rmatrix_string,nsim);

/* Construct H-test pvalue for the I(0) or Unit Root Null Model 
   
   Input
   							x_t =  DCT transformed Data
   							param = parameter for SD in H-test
   							itrend = 1 for demean, 2 for detrend
   							ind_int = 0 for I(0), 1 for I(1)
   							n_wsim = number of simulated sd paths
   							rmatrix_string = name of matrix with standard random variables ... on disk ... w draws
   							nsim = number of simulations for p-value
   							
   
   Output
                pv = pvalue for h test
*/

 
 local q,qq,t,psi,cov_ha_i0,cov_ha_i1,cov_ha_i2,cov_h0,cov_ha,cov_u,lr,a,xsim,lr_sim,pv;
 local tmp;
 
 q=rows(x_t);
 qq=q*(q+1)/2;
 t=1000;       @ sample size for asymptotic approximations @
 @ Construct PSI  @
 if itrend .== 1;
   psi=psi_compute(t,q,itrend);
 elseif itrend .== 2;
 	 psi=psi_compute(t,q+1,itrend);
 endif;
 
 @ Construct Appropriate Covariance Matrices @
 {cov_ha_i0,cov_ha_i1,cov_ha_i2}=h_cov_ha_i0_i1_i2(psi,param,n_wsim,rmatrix_string);
 if ind_int .== 0;
  cov_h0=psi'psi;
  cov_ha=cov_ha_i0;
 elseif ind_int .== 1;
 	cov_u=rw_cov(t);
 	cov_h0=psi'cov_u*psi;
 	cov_ha=cov_ha_i1;
 endif;
 
 @ Construct Test Statistic @
 lr=lrstat_vec(x_t,cov_h0,cov_ha);
 @ Compute Simulations for p-value @
 xsim=rndn(q,nsim);
 a=chol(cov_h0);
 xsim=a'xsim;
 lr_sim=lrstat_vec(xsim,cov_h0,cov_ha);
 pv=meanc(lr_sim .> lr);
 
 retp(pv);
endp;