proc(1) = LFST_PV(x_t,itrend,param_m,param_t,nsim);

/* Compute LFST Test Pvalue

Input:     x_t:      DCT transformed data
           itrend:   1 if demeaned, 2 if detrended
           param_m:  "g" parameter for demeaned alternative
           param_t:  "g" parameter for detrended alternative
           nsim:     number of simulations to compute p-value
           
Output:    P-vlaue for LFST Test
*/


@ -- Compute POI Unit Root test using low frequency obs @
local t,q,psi,cov_u,cov_h0,cov_ha,chol_cov_h0,a,x_t_trans,cov_ha_trans,lr,xsim,lr_sim,pv;
local tmp,tmp1,g_t,gt2;

t=1000;   @ Sample Size Used for Asymptotic Approximation @
q=rows(x_t);
@ Compute Null and Alternative Covariance Matrices @
if itrend .== 1;
 psi=psi_compute(t,q,itrend);
 cov_h0=psi'psi;
 g_t=param_m/t;
 gt2=g_t*g_t;
 tmp=rw_cov(t);
 tmp=gt2*tmp;
 tmp1=diag(tmp)+ones(t,1);
 cov_u=diagrv(tmp,tmp1);
 cov_ha=psi'cov_u*psi;
elseif itrend .== 2;
 psi=psi_compute(t,q+1,itrend);
 cov_h0=psi'psi;
 g_t=param_t/t;
 gt2=g_t*g_t;
 tmp=rw_cov(t);
 tmp=gt2*tmp;
 tmp1=diag(tmp)+ones(t,1);
 cov_u=diagrv(tmp,tmp1);
 cov_ha=psi'cov_u*psi;
endif;

@ Compute Test Statistic @
 chol_cov_h0=chol(cov_h0);
 a=inv(chol_cov_h0');
 x_t_trans=a*x_t;  @ X transformed under Ho @
 cov_ha_trans=a*cov_ha*a';        @ Covariance under Ha Transformed @    
 @ Note ... LF under Ho is unity @
 lr=marg_lf(x_t_trans,cov_ha_trans);

@ Simulations for Pvalue @
 xsim=rndn(rows(x_t),nsim);
 lr_sim=marg_lf(xsim,cov_ha_trans);
 pv=meanc( lr_sim  .> (lr - .0001) );
 
retp(pv);
endp;