proc(1) = lrstat_vec(x,cov,cov_a);

@ Compute lrstat @

/*
    Input:  x = n x nsim matrix of data ... nsim may be > 1 for use in simulations
            cov = null covariance matrix ... stored as full matrix
            cov_a = vectorized version of a set of covariance matrices under the alternative
                    LR is computed by averaging over LR using these covariance matrices 
            
    output 
            lrstat = nsim x 1 vector of lbim statistics 
*/

 local q,qq,lf_h0,lf_ha,i,cov_ha,lf_ha_avg,lrstat;

 @ Various Parameters and Matrices for testing @
 q=rows(x);
 qq=q*(q+1)/2; 
 
 @ Compute likelihood under ho @
 lf_h0=marg_lf(x,cov);
 lf_ha=miss(zeros(cols(x),cols(cov_a)),0);
 for i (1,cols(cov_a),1);
  cov_ha=xpnd(cov_a[1:qq,i]);
  lf_ha[.,i]=marg_lf(x,cov_ha);
 endfor;
 lf_ha_avg=meanc(lf_ha');
 lrstat=lf_ha_avg./lf_h0;
 
 retp(lrstat);
endp;   