proc(1) = marg_lf(x,cov);

@ This is a scaled version of the density in King and Hillier (1985) Equation (2) @

@ -- Note x is ncov x n ... compute n marginal likelihood values @


local m,d,c,tmp,mlf;

@ Compute Marginal Likelihood value for x with covariance matrix cov @
x=x./sqrt(sumc(x.^2))';   @ Normalize X to have unit length @
m=rows(x);
d=det(cov);
c=chol(invpd(cov));
x=c*x;
tmp=sumc(x.^2);
tmp=d*(tmp.^m);
mlf=sqrt(1./tmp);
retp(mlf);
endp;