proc(1) = nyb_rob(y,itrend,nar);

/* -- Robust Nyblom/KPSS I(0) test 
 y -- data
 itrend -- demean or detrend
 nar -- number of lags of y for AR spectral density estimator
 
 returns:
 nyb_rob1 = test statistic using AR spectral estimator
 nyb_rob2 = NW with 0.75*T^1/3 lags
*/

local t, x, e, nyb, rho, vare, lrmat, nyb_rob1, nma, kern, i, ii, nyb_rob2, r1, r2;


t=rows(y);
x=ones(t,1);
if itrend .== 2;
 x=x~seqa(1,1,t);
endif;
y=y-x*(invpd(x'x))*(x'y);
e=cumsumc(y);
nyb=sumc(e.^2)/(t*t);

@ Denominator @

@ AR Spectral Estimator @

x=miss(zeros(t-nar,nar),0);
i=1; do while i <= nar;
 x[.,i]=y[nar+1-i:t-i];
i=i+1; endo;

rho=invpd(x'x)*x'y[nar+1:t];
e=y[nar+1:t]-x*rho;
vare=e'e/(t-nar-nar);
lrmat=vare/((1-sumc(rho))^2);
nyb_rob1=nyb/lrmat;

@ Newey-West @
nma=floor(0.75*t^(1/3));
kern=zeros(nma+1,1);
ii = 0; do while ii <= nma;
  kern[ii+1,1]=(1-(ii/(nma+1)));
ii=ii+1; endo;

lrmat=0;
ii = -nma; do while ii <= nma;
 if ii <= 0; r1=1; r2=rows(y)+ii; else; r1=1+ii; r2=rows(y); endif;
 lrmat=lrmat + kern[abs(ii)+1,1]*(y[r1:r2,.]'y[r1-ii:r2-ii,.]);
ii=ii+1; endo;
 lrmat = lrmat/(rows(y));
 nyb_rob2=nyb/lrmat;

retp(nyb_rob1|nyb_rob2);
endp;