 proc(1) = s_cov_ha_2s(cov_h0,param,nsim,rmatrix_string);
 
 /* Generate nsim HA covariance matrices for S-test 
    
    Use Random walk and -RandomWalk for Symmetry ... reduces variability
    
    Input
         cov_h0 = covariance matrix under h0
         param = local parameter 
         nsim = number of simulations
         rmatrix_string = name of matrix with standard random variables ... on disk
    
    Output
         Cov_ha = vectorized version of cov_ha
 
 */
 
 local q, delta, gam, qq, cov_ha,i, lam, tmp;

 q=rows(cov_h0);
 qq=q*(q+1)/2;

 load delta=^rmatrix_string;
 delta=cumsumc(delta[1:q,1:nsim])/sqrt(q);   @ Random Walk @
 delta=(param/sqrt(q))*delta;
 delta=delta~(-delta);
 gam=exp(delta);
 cov_ha=miss(zeros(qq,cols(delta)),0);
 for i (1,cols(delta),1);
  tmp=(cov_h0.*gam[.,i]).*gam[.,i]';  @ A * Cov_h0 * A' where A is diag with gam[,.i] on diag @
  cov_ha[.,i]=vech(tmp);
 endfor;

retp(cov_ha);
endp;