@ ------------------------------------------------------------------ @
proc(1) = stest_pv(x_t,cov_h0,param,n_dsim,rmatrix_string,nsim);

/* Construct S-test pvalue for the null model with covariance matrix cov_h0
   
   Input
   							x_t =  DCT transformed Data
   							param = parameter for SD in H-test
   							n_dsim = number of simulated delta paths
   							rmatrix_string = name of matrix with standard random variables ... on disk ... delta draws
   							nsim = number of simulations for p-value
   							
   
   Output
                pv = pvalue for s test
*/
 
 local q,cov_ha,lr,a,xsim,lr_sim,pv;
 
 q=rows(x_t);
 cov_ha=s_cov_ha(cov_h0,param,n_dsim,rmatrix_string);
 
 @ Construct Test Statistic @
 lr=lrstat_vec(x_t,cov_h0,cov_ha);
 @ Compute Simulations for p-value @
 xsim=rndn(q,nsim);
 a=chol(cov_h0);
 xsim=a'xsim; 
 lr_sim=lrstat_vec(xsim,cov_h0,cov_ha);
 pv=meanc(lr_sim .> lr);
 
 retp(pv);
endp;