% Table 1 .. AER_PP_2014 
% 

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
% -- File Directories 
outdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/mat/';

% -- Read in Data 
load_data = 1;  % 1 if reloading data from Excel, etc 
data_assa;

infl = d_p_pce_lfe;
u = urate_all;

% Compute Average Inflation Rate over Specific Periods
ismpl = smpl(calvec,[1979,2],[1979,4],4);
infl_79 = mean(infl(ismpl==1));
u_79 = mean(u(ismpl==1));
ismpl = smpl(calvec,[2007,2],[2007,4],4);
infl_07 = mean(infl(ismpl==1));
u_07 = mean(u(ismpl==1));
ismpl = smpl(calvec,[1985,2],[1985,4],4);
infl_85 = mean(infl(ismpl==1));
u_85 = mean(u(ismpl==1));
ismpl = smpl(calvec,[2013,1],[2013,3],4);
infl_13 = mean(infl(ismpl==1));
u_13 = mean(u(ismpl==1));

ismpl = smpl(calvec_m,[1980,1],[1985,12],12);
[umax_85,ii]=max(urate_m(ismpl==1));
tmp = calds_m(ismpl==1,:);
dmax_85 = tmp(ii,:);

ismpl = smpl(calvec_m,[2007,12],[2013,11],12);
[umax_13,ii]=max(urate_m(ismpl==1));
tmp = calds_m(ismpl==1,:);
dmax_13 = tmp(ii,:);

fprintf('avg inflation 79:q2-79:q4 = ');
fprintf('%5.1f \n',infl_79);
fprintf('avg inflation 85:q2-85:q4 = ');
fprintf('%5.1f \n',infl_85);
fprintf('Difference = ');
fprintf('%5.1f \n',infl_85-infl_79);
fprintf('avg urate 79:q2-79:q4 = ');
fprintf('%5.1f \n',u_79);
fprintf('peak urate 79-85 = ');
fprintf('%5.1f %4.0f %4.0f \n',umax_85,dmax_85(1,1), dmax_85(1,2));
fprintf('dif beg to peak = ');
fprintf('%4.1f \n',umax_85-u_79);
fprintf('dif beg to end = ');
fprintf('%4.1f \n',u_85-u_79);
fprintf('\n');
fprintf('avg inflation 07:q1-07:q3 = ');
fprintf('%5.1f \n',infl_07);
fprintf('avg inflation 1:3q1-13:q3 = ');
fprintf('%5.1f \n',infl_13);
fprintf('Difference = ');
fprintf('%5.1f \n',infl_13-infl_07);
fprintf('avg urate 07:q1-07:q3 = ');
fprintf('%5.1f \n',u_07);
fprintf('peak urate 07-13 = ');
fprintf('%5.1f %4.0f %4.0f \n',umax_13,dmax_13(1,1), dmax_13(1,2));
fprintf('dif beg to peak = ');
fprintf('%4.1f \n',umax_13-u_07);
fprintf('dif beg to end = ');
fprintf('%4.1f \n',u_13-u_07);

