% data_assa.m
% December 21, 2013, MWW
% 
misscode = 1.0e+32;
xlsname = '/Users/mwatson/Dropbox/ASSA14/ddisk/data/AER_PP2014_Data.xlsx';
ns_m = 4;
ns_q = 5;
fyear = 1947;
lyear = 2013;
fmonth = 1;
lmonth = 11;
fquarter = 1;
lquarter = 3;
[dnobs_m,calvec_m,calds_m] = calendar_make(fyear,lyear,fmonth,lmonth,12);
[dnobs_q,calvec_q,calds_q] = calendar_make(fyear,lyear,fquarter,lquarter,4);
calvec = calvec_q;
dnobs = dnobs_q;
calds = calds_q;


if load_data == 1;

  % ----------- Monthly Series ---------
  sheet = 'Monthly';
  ndesc = 1;
  ncodes = 0;
  [namevec,descmat,tcodemat,datestring,datamat] = readxls(xlsname,sheet,ns_m,dnobs_m,ndesc,ncodes);
  labelvec=descmat(:,1);
  % Convert Namestrings to upper case 
  namevec = upper(namevec);
  % Eliminate any leading or trailing blanks 
  namevec=strtrim(namevec);
  
  % --- Get Series 
  str='CLF16OV';    % Labor Force
  str=upper(str);
  j = colnumber(str,namevec);
  x = datamat(:,j);
  ii = x == misscode;
  x(ii==1) = NaN;
  lf_m = x;
  lf=mtoq(x,calds_m,calds_q,0);
  %plot(calvec,lf);
  
  str='UNRATE';    % Unrate
  str=upper(str);
  j = colnumber(str,namevec);
  x = datamat(:,j);
  urate_1_m = x;
  urate_1=mtoq(x,calds_m,calds_q,0);  % One Digit
  %plot(calvec,urate);
  
  str='UNEMPLOY';    % Number Unemployed
  str=upper(str);
  j = colnumber(str,namevec);
  x = datamat(:,j);
  n_unemployed_m = x;
  
  str='UEMP27OV';    % Number Unemployed 27 weeks or more
  str=upper(str);
  j = colnumber(str,namevec);
  x = datamat(:,j);
  n_unemployed27ov_m = x;
  
  urate_m = 100*n_unemployed_m./lf_m;
  urate27ov_m = 100*n_unemployed27ov_m./lf_m;
  uratelt27_m = 100*(n_unemployed_m-n_unemployed27ov_m)./lf_m;
  urate_all = mtoq(urate_m,calds_m,calds_q,0);
  urate_27ov = mtoq(urate27ov_m,calds_m,calds_q,0);
  urate_lt27 = mtoq(uratelt27_m,calds_m,calds_q,0);  
  
 
  % ----------- QuarterlySeries ---------
  sheet = 'Quarterly';
  ndesc = 1;
  ncodes = 0;
  [namevec,descmat,tcodemat,datestring,datamat] = readxls(xlsname,sheet,ns_q,dnobs_q,ndesc,ncodes);
  labelvec=descmat(:,1);
  % Convert Namestrings to upper case 
  namevec = upper(namevec);
  % Eliminate any leading or trailing blanks 
  namevec=strtrim(namevec);
  
  str='pimp';    % 
  str=upper(str);
  j = colnumber(str,namevec);
  p_imp = datamat(:,j);
  %plot(calvec,pimp);
  
  str='pimp_np';    % 
  str=upper(str);
  j = colnumber(str,namevec);
  p_imp_np = datamat(:,j);
  %plot(calvec,[pimp_np,pimp]);

  str='gdpctpi';    % 
  str=upper(str);
  j = colnumber(str,namevec);
  p_gdp = datamat(:,j);
  %plot(calvec,p_gdp);
  
  str='jcxfe';    % 
  str=upper(str);
  j = colnumber(str,namevec);
  p_pce_lfe = datamat(:,j);
  %plot(calvec,p_pce_lfe);
  
  str='pcectpi';    % 
  str=upper(str);
  j = colnumber(str,namevec);
  p_pce = datamat(:,j);
  %plot(calvec,p_pce);
  
  %Link pimp to pimp_np in 1967:Q1
  ismpl = smpl(calvec,[1967,1],[1967,1],4);
  [tmp,ii]=max(ismpl);
  p_imp_npl = p_imp_np;
  p_imp_npl(1:ii-1)=p_imp(1:ii-1)*(p_imp_np(ii)/p_imp(ii));
  %[calvec/100,pimp,pimp_np,pimp_npl]
    
  % Inflation and Change in inflation
  slist = {
           'p_gdp' ...
           'p_pce_lfe' ...
           'p_pce' ...
           'p_imp_npl' ...
           'p_imp' ...
          }';
  for iseries = 1:size(slist,1);
     ustr = char(slist(iseries));
     eval(['u = ' ustr ';']);
     du = NaN*zeros(dnobs,1);
     d4u = NaN*zeros(dnobs,1);
     ddu = NaN*zeros(dnobs,1);
     du(2:dnobs) = 400*log(u(2:dnobs)./u(1:dnobs-1));
     ddu(2:dnobs) = du(2:dnobs)-du(1:dnobs-1);
     d4u(5:dnobs) = 100*log(u(5:dnobs)./u(1:dnobs-4));
     d_ustr = ['d_' ustr];
     dd_ustr = ['dd_' ustr];
     d4_ustr = ['d4_' ustr];
     eval([d_ustr '= du;']);
     eval([dd_ustr '= ddu;']);
     eval([d4_ustr '= d4u;']);
  end;
  
  
  % Save Series 
  slist = {...
           'lf' ... 
           'urate_all' ...   
           'urate_lt27' ...
           'urate_27ov' ...
           'p_pce_lfe' ...
           'p_pce' ...
           'p_gdp' ...
           'p_imp' ...
           'p_imp_npl' ...
           'd_p_pce_lfe' ...
           'd_p_pce' ...
           'd_p_gdp' ...
           'd_p_imp_npl' ...
           'd_p_imp' ...
           'dd_p_pce_lfe' ...
           'dd_p_pce' ...
           'dd_p_gdp' ...
           'dd_p_imp_npl' ...
           'dd_p_imp' ...
           'd4_p_pce_lfe' ...
           'd4_p_pce' ...
           'd4_p_gdp' ...
           'd4_p_imp_npl' ...
           'd4_p_imp' ...
          }';
  for iseries = 1:size(slist,1);
     ustr = char(slist(iseries));
     eval(['u = ' ustr ';']);
     if iseries == 1;
       datamat = u;
     else;
       datamat = [datamat u];
     end;
  end;
  str_tmp = [matdir 'slist'];
  save(str_tmp,'slist'); 
  str_tmp = [matdir 'datamat'];
  save(str_tmp,'datamat'); 
  
end;
  
% Load Variables and Give Standard Names 
str_tmp = [matdir 'slist'];
load(str_tmp); 
str_tmp = [matdir 'datamat'];
load(str_tmp);
for iseries = 1:size(slist,1);
   ustr = char(slist(iseries));
   eval([ustr '=datamat(:,iseries);']);
end;


