function [eps,eta,fac_draw,fac_filt_mean,fac_filt_var] = draw_eps_eta(y,var_eps,var_eta)
% 
%       Y: T x 1
%       var_eps: T x 1
%       var_eta: T x 1
%       
%       Output
%       eps: Tx1 -- epsilon draw
%       eta: Tx1 -- eta draw
%       fac_draw: tx1 -- draw of factors from smoothed distribution
%       fac_filt_mean: Tx1 -- filtered mean of factors (x1t)
%       fac_filt_var: Tx1 -- variance of filtered series (p1t)
%       
small=1.0e-06;
% P matrices 
 nobs=size(y,1);
 p1t=zeros(nobs+1,1);
 p2t=zeros(nobs+1,1);
 x1t=zeros(nobs+1,1);
 x2t=zeros(nobs+1,1);
 x3_draw=zeros(nobs+1,1);
 
% KF Using Special Structure of Problem 
 x1=0;
 p1=small;        % initial are assumed known 
 x1t(1,1)=x1; 
 p1t(1,1)=p1;
 for t=1:nobs;
 	x2=x1;
  p2=p1+var_eps(t);
  e=y(t)-x2;
  ht=p2+var_eta(t);
  hti=1/ht;
  k=p2*hti;
  x1=x2+k*e;
  p1=(1-k)*p2;
  x1t(t+1,1)=x1;
  p1t(t+1,1)=p1;
  x2t(t+1,1)=x2;
  p2t(t+1,1)=p2;
 end;
 
 % Generate Random Draws from Smoothed Distribution 
 x3mean=x1;
 p3=p1;
 chol_p=sqrt(p3);
 x3=x3mean+chol_p*randn(1,1);
 x3_draw(nobs+1,1)=x3;
 for t=nobs:-1:2;
  x2=x2t(t+1);
  p2=p2t(t+1);
  x1=x1t(t);
  p1=p1t(t);
  p2i=1/p2;
  k=p1*p2i;
  e=x3-x2;
  x3mean=x1+k*e;
  p3=(1-k)*p1;
  chol_p=sqrt(p3);
  x3=x3mean+chol_p*randn(1,1);
  x3_draw(t,1)=x3; 
 end;
 fac_draw=x3_draw(2:nobs+1);
 eps=x3_draw(2:nobs+1)-x3_draw(1:nobs);
 eta=y-x3_draw(2:nobs+1);
 fac_filt_mean=x1t(2:nobs+1);
 fac_filt_var=p1t(2:nobs+1);

end