function [vardraw,r_pt] = draw_var1(x,r_pt,gam,var_min,r_sig2,r_m1,r_m2,r_p)

r_sig=sqrt(r_sig2);
vague = 1.0e+6;  % large number     
n=size(x,1);
% Construct estimate of var_e @
lnres2=log(x.^2);
     
% -- Step 1 -- initial draws of Indicator Variables -- 
tmp=rand(n,1);
ir = tmp<=r_pt;

% -- Step 2; compute system parameters given indicators -- 
mut = (ir*r_m1) + ((1-ir)*r_m2);

 % Kalman Filtering 
 ye=lnres2-mut;
 p1t=zeros(n+1,1);
 p2t=zeros(n+1,1);
 x1t=zeros(n+1,1);
 x2t=zeros(n+1,1);
 x3_draw=zeros(n+1,1);

 % -- Compute Covariance Matrix  -- 
 x1=0;
 p1=vague;
 x1t(1,1)=x1; 
 p1t(1,1)=p1;
 for t=1:n;
 	x2=x1;
 	p2=p1+gam;
 	h=p2+r_sig2;
 	k=p2/h;
 	p1=p2-k*p2;
 	x1=x2+k*(ye(t)-x2);
 	p1t(t+1,1)=p1;
 	p2t(t+1,1)=p2;
 	x1t(t+1,1)=x1;
 	x2t(t+1,1)=x2;
 end;
 utmp=randn(n+1,1);
 x3mean=x1;
 p3=p1;
 chol_p=sqrt(p3);
 x3=x3mean+chol_p*utmp(n+1,1);
 x3_draw(n+1,1)=x3;

 for t=n:-1:2;
  x2=x2t(t+1,1);
  p2=p2t(t+1,1);
  x1=x1t(t,1);
  p1=p1t(t,1);
  p2i=1/p2;
  k=p1*p2i;
  x3mean=x1+k*(x3-x2);
  p3=p1-k*p1;
  chol_p=sqrt(p3);
  x3=x3mean+chol_p*utmp(t,1);
  x3_draw(t,1)=x3;
 end;
 
 adraw1=x3_draw(2:n+1);
 edraw=lnres2-adraw1;

 % -- Compute Mixture Probabilities -- 
  % -- e shocks -- (Note sigma is the same) -- 
  f1=exp(   (-0.5)* (((edraw-r_m1)./r_sig).^2)  );
  f2=exp(   (-0.5)* (((edraw-r_m2)./r_sig).^2)  );
  fe= r_p*f1 + (1-r_p)*f2;
  r_pt=(r_p*f1)./fe;
  
  % -- Compute Variance of AR Shocks and Variance of Annual Difs -- 
  vardraw = exp(adraw1); % Variance Draw 
  
 % -- Impose minimum value --- 
 tmp=var_min*ones(size(vardraw));
 vardraw=max(vardraw,tmp);
 
end
 
