function [ nix_on, nix_off ] = gordn82q_2(calvecq);

% -- Compute the Variable "Gordon82"
%     to model effect of Nixon wage and price controls 
%     this is a quatertly series
%
%    Series values:
%    
%     -- monthly -- 
%     0.8 from 1971:7-1972:9
%    -0.4 from 1974:4-1974:6
%    -1.6 from 1974:7-1974:12
%    -0.4 from 1975:1-1975:3
%
%     -- quarterly -- 
%     0.8 from 1971:3-1972:3
%    -0.4 from 1974:2-1974:2
%    -1.6 from 1974:3-1974:4
%    -0.4 from 1975:1-1975:1  
%
i1 = smpl(calvecq,[1971,3],[1972,3],4);
i2 = smpl(calvecq,[1974,2],[1974,2],4);
i3 = smpl(calvecq,[1974,3],[1974,4],4);
i4 = smpl(calvecq,[1975,1],[1975,1],4);

nix_on = (0.8*i1);
nix_off = (-.4*i2) + (-1.6*i3) + (-.4*i4);
