% infl_ucsv.m
%   Compute UC model with Stochastic volatility
%   Save
%   (a) filtered taus (and SEs)
%   (b) smoothed taus (and SEs)
%   (c) Volatilities
%   (d) MA Coefficient
%   (e) MA error Variance

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rndseed = 29721;
% -- File Directories 
outdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/dir/';
matdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/mat/';

% -- Read in Data 
load_data = 0;  % 1 if reloading data from Excel, etc 
data_assa;


% Sample Period and So Forth 
first_obs=[1953,1];
nfirst=first_obs(1)+(first_obs(2)-1)/4;

% Series  
  slist = {...
           'd_p_pce_lfe' ...
          }';

calvec_save=calvec;
dnobs_save=dnobs;

% Set Up Analysis for MCMC Draws of variances and factors 
burnin=1000;    % Discarded draws 
ndraw=10000;    % Number of draws after burnin 

for ip = 1:size(slist,1);
 calvec=calvec_save;
 dnobs=dnobs_save;
 pstr = char(slist(ip));
 eval(['dp = ' pstr ';']);
 % Select Data to Use 
 ismpl = calvec>nfirst-.001;
 dp = dp(ismpl);
 calvec = calvec(ismpl);
 tmp = packr([dp,calvec]);
 dp = tmp(:,1);
 calvec = tmp(:,2);
 dnobs = size(calvec,1);
 y = dp;

 % -- Parameters for log-chi-squared errors -- 
 r_p=.086;
 r_m1=-7.472;
 r_m2=-0.698;
 r_sig2=1.411;
 r_sig=sqrt(r_sig2);

 % -- Parameters for RW Innovation Variance -- 
 gam_sqrt=.20;    % SD 
 gam=gam_sqrt^2;  % Gamma -- variance of innovation in ln(sigma^2)) 
 
 % Parameters for Initial Conditions, bounds and so forth 
 % Set tau0 = average of first few observations 
   tau0=mean(y(1:4));
   y=y-tau0; % Eliminate intial value of tau from analysis 
    
 % Compute variance of dy for use in constructing bounds and initial conditions 
  dy=y(2:end)-y(1:end-1);
  var_dy = (std(dy))^2;
 
  
 % Lower Bounds on variances -- 
 %     -- these are needed to keep algorith away from boundary
 %     -- the values are problem specific: these values work well for US Inflation 
 
   var_eta_min = 0.015*var_dy;
 %  var_eps_min = 0.005*var_dy;
   var_eps_min = 0.0005*var_dy;

  % Initial Values: these values work well for US Inflation 
   var_eps_initial = var_dy/3;
   var_eta_initial = var_dy/3;
 
  
   % "Carry Out Analysis for series ";;pstr;
   % "Lower bound on SD eta = ";;sqrt(var_eta_min);
   % "Lower bound on SD eps = ";;sqrt(var_eps_min);  
   % "Initial guess of sd_eta = ";;sqrt(var_eta_initial);
   % "Initial guess of sd_eps = ";;sqrt(var_eps_initial);     
      
 % -- Matrices for Saving Summary Statistics 
 fac_filtered_sum=zeros(dnobs,1);            % Sum of Sum 
 fac_filtered_squared_sum=zeros(dnobs,1);    % f(t/t)^2 + p(t/t) = E(f(t)^2 given parameters and data  
 fac_draw_sum=zeros(dnobs,1);               
 fac_draw_squared_sum=zeros(dnobs,1);      
 fac_draw_sum=zeros(dnobs,1);  
 
 theta_sum = zeros(dnobs,1);
 theta_sum_squared = zeros(dnobs,1);
 sd_a_sum = zeros(dnobs,1);
 sd_a_sum_squared = zeros(dnobs,1);
 sigma_eps_sum = zeros(dnobs,1);
 sigma_eta_sum = zeros(dnobs,1);

 % -- step 0 -- 
  % -- initial values of indicator prob vectors -- 
  r_pt_eps = r_p*ones(dnobs,1);
  r_pt_eta = r_p*ones(dnobs,1);
  
  % -- initial values of variances -- 
  var_eps=ones(dnobs,1)*var_eps_initial;          % Same Notation as QEPD -- state error variance (Q)  
  var_eta=ones(dnobs,1)*var_eta_initial;          % Same Notation as QEPD -- signal error variance (R)
 
   
  itmp=0;
  tic;
  for idraw=1:ndraw+burnin;
  	% Draw Factors and Shocks 	
    [eps,eta,fac_draw,fac_filt_mean,fac_filt_var] = draw_eps_eta(y,var_eps,var_eta); 
    filt_f_draw = fac_filt_mean + sqrt(fac_filt_var).*rand(dnobs,1);   % Note ... this draws from time "t" marginal, not joint over t 
    
    % Draw of variances 
   	[var_eps,r_pt_eps] = draw_var1(eps,r_pt_eps,gam,var_eps_min,r_sig2,r_m1,r_m2,r_p);
    [var_eta,r_pt_eta] = draw_var1(eta,r_pt_eta,gam,var_eta_min,r_sig2,r_m1,r_m2,r_p);
   	% MA Coefficient and Standard Deviation of MA innovation 
    lam0=var_eps+2*var_eta;
    rho1=-var_eta./lam0;
    theta=-(ones(size(rho1))-sqrt(ones(size(rho1))-4*rho1.^2))./(2*rho1);
    var_a=lam0./(ones(size(rho1))+theta.^2);
    sd_a=sqrt(var_a);
    if idraw > burnin;
     fac_filtered_sum=fac_filtered_sum+fac_filt_mean;
     fac_filtered_squared_sum=fac_filtered_squared_sum+(fac_filt_mean.^2)+fac_filt_var;
     fac_draw_sum = fac_draw_sum + fac_draw;
     fac_draw_squared_sum = fac_draw_squared_sum + fac_draw.^2;
     theta_sum = theta_sum + theta;
     theta_sum_squared = theta_sum_squared + theta.^2;   
     sd_a_sum = sd_a_sum + sd_a;
     sd_a_sum_squared = sd_a_sum_squared + sd_a.^2; 
     sigma_eps_sum = sigma_eps_sum + sqrt(var_eps);
     sigma_eta_sum = sigma_eta_sum + sqrt(var_eta);   
    end;
    
    if idraw == burnin+1;
     fac_draw_save=fac_draw;
     fac_f_draw_save=filt_f_draw;
     eps_save=sqrt(var_eps);
     eta_save=sqrt(var_eta);
     theta_save = theta;
    elseif idraw > burnin+1;
     fac_draw_save=[fac_draw_save,fac_draw];
     fac_f_draw_save=[fac_f_draw_save,filt_f_draw];
     eps_save=[eps_save,sqrt(var_eps)];
     eta_save=[eta_save,sqrt(var_eta)]; 
     theta_save = [theta_save,theta];
    end;
    
    itmp=itmp+1;
    if itmp == 1000;
      itmp=0;
      idraw;
      pstr;
      toc
      tic;
    end;
  end;  
  
  % Compute mean and standard deviation across draws of factors and standard deviations 
  fac_f_mean=fac_filtered_sum/ndraw;
  tmp=fac_filtered_squared_sum/ndraw;
  fac_f_sd=sqrt(tmp-fac_f_mean.^2); 
  fac_mean=fac_draw_sum/ndraw;
  fac_squared_mean = fac_draw_squared_sum/ndraw;
  fac_sd = sqrt(fac_squared_mean - fac_mean.^2);
  theta_mean=theta_sum/ndraw;
  theta_squared_mean = theta_sum_squared/ndraw;
  theta_sd = sqrt(theta_squared_mean-theta_mean.^2);
  sd_a_mean=sd_a_sum/ndraw;
  sd_a_squared_mean = sd_a_sum_squared/ndraw;
  sd_a_sd = sqrt(sd_a_squared_mean-sd_a_mean.^2);  
  sigma_eps_mean=sigma_eps_sum/ndraw;
  sigma_eta_mean=sigma_eta_sum/ndraw;
  
  pctvec=[0.05,0.1,0.25,0.5,0.75,0.90,0.95]';
  tmp=NaN*zeros(size(fac_mean,1),size(pctvec,1));
  fac_pct=tmp;
  fac_f_pct=tmp;
  sigma_eps_pct=tmp;
  sigma_eta_pct=tmp;
  theta_pct = tmp;
  for t=1:size(fac_pct,1);
  	fac_pct(t,:)=(pctile(fac_draw_save(t,:)',pctvec))';
    fac_f_pct(t,:)=(pctile(fac_f_draw_save(t,:)',pctvec))';
  	sigma_eps_pct(t,:)=(pctile(eps_save(t,:)',pctvec))';
   	sigma_eta_pct(t,:)=(pctile(eta_save(t,:)',pctvec))'; 
    theta_pct(t,:)=(pctile(theta_save(t,:)',pctvec))'; 
  end;
  
  
  % Add Initial Value into permanent component 
  fac_mean=fac_mean+tau0;
  fac_f_mean=fac_f_mean+tau0;
  y=y+tau0;
  fac_pct=fac_pct+tau0;
  fac_f_pct = fac_f_pct + tau0;
  
  % Find First/Last Date in this sample 
  [tmp,cal_min_ind] = min(abs(calvec_save-calvec(1)));
  [tmp,cal_max_ind] = min(abs(calvec_save-calvec(end)));
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=sigma_eta_mean;
  sigma_eta_mean=tmp;
  str_tmp = [matdir pstr '_sigma_eta_mean'];
  save(str_tmp,'sigma_eta_mean');
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=sigma_eps_mean;
  sigma_eps_mean=tmp;
  str_tmp = [matdir pstr '_sigma_eps_mean'];
  save(str_tmp,'sigma_eps_mean'); 
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=fac_mean;
  fac_mean=tmp;
  str_tmp = [matdir pstr '_fac_mean'];
  save(str_tmp,'fac_mean'); 
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=theta_mean;
  theta_mean=tmp;
  str_tmp = [matdir pstr '_theta_mean'];
  save(str_tmp,'theta_mean');
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=theta_sd;
  theta_sd=tmp; 
  str_tmp = [matdir pstr '_theta_sd'];
  save(str_tmp,'theta_sd'); 
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=sd_a_mean;
  sd_a_mean=tmp;
  str_tmp = [matdir pstr '_sd_a_mean'];
  save(str_tmp,'sd_a_mean');
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=sd_a_sd;
  sd_a_sd=tmp; 
  str_tmp = [matdir pstr '_sd_a_sd'];
  save(str_tmp,'sd_a_sd');
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=fac_f_mean;
  fac_f_mean=tmp;
  str_tmp = [matdir pstr '_fac_f_mean'];
  save(str_tmp,'fac_f_mean'); 
  
  tmp = NaN*zeros(dnobs_save,1);
  tmp(cal_min_ind:cal_max_ind)=fac_f_sd;
  fac_f_sd=tmp; 
  str_tmp = [matdir pstr '_fac_f_sd'];
  save(str_tmp,'fac_f_sd'); 
    
  tmp = NaN*zeros(dnobs_save,size(pctvec,1));
  tmp(cal_min_ind:cal_max_ind,:)=sigma_eta_pct;
  sigma_eta_pct=tmp;  
  str_tmp = [matdir pstr '_sigma_eta_pct'];
  save(str_tmp,'sigma_eta_pct'); 
  
  tmp = NaN*zeros(dnobs_save,size(pctvec,1));
  tmp(cal_min_ind:cal_max_ind,:)=sigma_eps_pct;
  sigma_eps_pct=tmp; 
  str_tmp = [matdir pstr '_sigma_eps_pct'];
  save(str_tmp,'sigma_eps_pct'); 
  
  tmp = NaN*zeros(dnobs_save,size(pctvec,1));
  tmp(cal_min_ind:cal_max_ind,:)=fac_pct;
  fac_pct=tmp; 
  str_tmp = [matdir pstr '_fac_pct'];
  save(str_tmp,'fac_pct'); 
  
  tmp = NaN*zeros(dnobs_save,size(pctvec,1));
  tmp(cal_min_ind:cal_max_ind,:)=fac_f_pct;
  fac_f_pct=tmp; 
  str_tmp = [matdir pstr '_fac_f_pct'];
  save(str_tmp,'fac_f_pct');

  tmp = NaN*zeros(dnobs_save,size(pctvec,1));
  tmp(cal_min_ind:cal_max_ind,:)=theta_pct;
  theta_pct=tmp; 
  str_tmp = [matdir pstr '_theta_pct'];
  save(str_tmp,'theta_pct'); 
  
  
end;