% Counter factual values of inflation  
% 
clear all;
small = 1.0e-10;
big = 1.0e+6;                  
% -- File Directories 
outdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/mat/';


% ------- Parameters for Modeling ---------
price_str = 'd_p_pce_lfe';        % Inflation Series
urate_str = 'urate_all';          % Unemployment Rate Series -- Change this for PC estimates for urate_lt27 or urate_all

% -- Value of SD of innovation in NAIRU (Random Walk Formulation)
sigma_delta_ubar = 0.150;


% Counterfactual indicators
i_theta = 0;    % if 0 use 79-85 value, if 1 use 08-13 value
i_nairu = 0;    % if 0 use estimated NAIRU, if 1 hold NAIRU Constant during counterfactual period
i_z = 0;        % if 0 use actual value of z, if 1 set component to zero in counterfactual period
theta_0713 = 0.93;
theta_7985 = 0.67;

% -- Sample period for Estimation of PC
nfirst_pcest = [1960,2];
nlast_pcest = [2013,3];

% -- Sample Periods for Counterfactual
n_initial = [2007,3];
nfirst_cf = [2007,4];
nlast_cf = [2013,3];
n_avg_first = [2013,1];
n_avg_last = [2013,3];

% Regression equation 
i_ugap_1sd = 1;              % 1 if one-sided ugap is used; 0 if two-sided is used 
nlags_ugap = [0,1,2,3,4];    % Number of lags of ugap (>= 1)
i_nix = 1;                   % Nixon Controls
i_rpfe = 1;                  % Include rpfe
 nlags_rpfe = [1,2,3,4];     % Number of lag5
 i_d84 = 1;                  % 1 if break in 1985:q1
i_rpimp_np = 1;                 % Include rpfe
 nlags_rpimp_np = [0,1,2,3,4];    % Number of lags
 
% Parameter for Error Variance ... MA
nma_var_pi = 20;  % Window in symmetric nma on each side ... total number of terms = 2*nma+1

% -- Read in Data 
load_data = 0;  % 1 if reloading data from Excel, etc 
data_assa;

% Unemployment Rate and Inflation
eval(['dp = ' price_str ';']);
eval(['urate = ' urate_str ';']);

% Construct Gordon Controls
[nix_on,nix_off] = gordn82q(calvec);
dp_rpfe = d_p_pce - d_p_pce_lfe;
dp_rpimp_np = d_p_imp_npl - d_p_gdp;

% Gordon Controls Used in Regression
gdn_cntl = NaN*zeros(dnobs,1);
if i_nix == 1;
    gdn_cntl = [gdn_cntl,nix_on,nix_off];
end;
if i_rpfe == 1;
    for i=1:length(nlags_rpfe);
        gdn_cntl = [gdn_cntl,lag(dp_rpfe,nlags_rpfe(i))];
    end;
end;
if (i_rpfe*i_d84) == 1;
  ismpl = smpl(calvec,[1985,1],calds(end,:),4);
    for i=1:length(nlags_rpfe);
        gdn_cntl = [gdn_cntl,lag(dp_rpfe,nlags_rpfe(i)).*ismpl];
    end;
end;
if i_rpimp_np == 1;
    for i=1:length(nlags_rpimp_np);
        gdn_cntl = [gdn_cntl,lag(dp_rpimp_np,nlags_rpimp_np(i))];
    end;
end;


% Read in UCSV Results
% Load Results computed previously
str_tmp = [matdir price_str '_fac_mean'];
load(str_tmp);
str_tmp = [matdir price_str '_fac_f_mean'];
load(str_tmp); 
str_tmp = [matdir price_str '_fac_f_pct'];
load(str_tmp); 
fac_f_median = fac_f_pct(:,4);  % Percentiles (1 = 5, 2 = 10, 3 = 25, 4 = 50, 5 = 75, 6 = 90, 7 = 95)

dp_fe = NaN*zeros(dnobs,1);
%dp_fe(2:dnobs) = dp(2:dnobs)-fac_f_mean(1:dnobs-1); 
%dp_fe(2:dnobs) = dp(2:dnobs)-fac_f_median(1:dnobs-1);
dp_fe(2:dnobs) = dp(2:dnobs)-fac_f_median(1:dnobs-1); 


% ------------ BandPass Unemployment Rate
updc=2 ;       % Upper Period Cutoff for BP filter 
lpdc=60;       % Lower Period Cutoff for BP filter 
bpn=80;        % Number of Terms in BP filter (symmetric total terms = 2*bpn+1)
narpad=6;      % AR Order for Padding Series 
bp_seflag = 0; % 1 to compute SE, 0 for not 
bp_tcode = 0;  % 1 for FD
% -- 2-sided
[urate_bp,se] = bpassar(urate,updc,lpdc,bpn,narpad,bp_tcode,bp_seflag);
urate_trend_2sd = urate-urate_bp;
ugap_2sd = urate-urate_trend_2sd;
% --- 1-sided
nobs_min = 40;
[urate_bp1sd] = bpassar_1sd(urate,updc,lpdc,bpn,narpad,bp_tcode,nobs_min);
urate_trend_1sd = urate-urate_bp1sd;
ugap_1sd = urate-urate_trend_1sd;

if i_ugap_1sd == 1;
  ugap = ugap_1sd;
  utrend = urate_trend_1sd;
else;
  ugap = ugap_2sd;
  utrend = urate_trend_2sd;
end;
d_ugap = dif(ugap,1);


% Estimate Phillips Curve Regression
 ismpl = smpl(calvec,nfirst_pcest,nlast_pcest,4);
% -- Set up Y and X 
 Y = dp_fe;
 % ugap
   X = lag(ugap,nlags_ugap(1));
   for i = 2:length(nlags_ugap);
    X = [X,lag(ugap,nlags_ugap(i))];
   end;
 % Controls
   if size(gdn_cntl,2) > 1;
       X = [X,gdn_cntl(:,2:end)];
   end;
 
% Save full-sample values
 Y_fs = Y;
 X_fs = X;
 
% Estimation Sample
 tmp = [calvec,Y,X];
 tmp = tmp(ismpl==1,:);
 tmp = packr(tmp);
 cal_est = tmp(:,1);
 Y = tmp(:,2);
 X = tmp(:,3:end);
% Run Regression
[bhat,vbeta,se_beta,ser,rbar_sq] = hac(Y,X,4,1);
fprintf('Regression Results \n');
fprintf('Bhat and SE = \n');
fprintf('%11.4e %11.4e \n',[bhat,se_beta]);
fprintf('ser = %6.3f \n',ser);
fprintf('rbarsquared = %6.3f \n',rbar_sq);
% Sum of Coefficients on ugap
nugap = length(nlags_ugap);
tmp = zeros(length(bhat),1);
tmp(1:nugap) = ones(nugap,1);
% Print out detailed results
ii=0;
% Ugap
fprintf('sum for ugap = ');
bzero=zeros(length(bhat),1);
jj = length(nlags_ugap);
tmp = bzero;
tmp(ii+1:ii+jj) = ones(jj,1);
fprintf('%11.4f %11.4f \n',[tmp'*bhat,sqrt(tmp'*vbeta*tmp)]);
ii = ii+jj;
b_ugap = tmp'*bhat;
se_b_ugap = sqrt(tmp'*vbeta*tmp);
% Nixon
if i_nix == 1;
 fprintf('nixon \n');
 fprintf('%11.4e %11.4e \n',[bhat(ii+1:ii+2,:),se_beta(ii+1:ii+2,:)]);
 ii = ii+2;
end;
if i_rpfe == 1;
 fprintf('rpfe = ');
 jj = length(nlags_rpfe);
 tmp = bzero;
 tmp(ii+1:ii+jj) = ones(jj,1);
 fprintf('%11.4f %11.4f \n',[tmp'*bhat,sqrt(tmp'*vbeta*tmp)]);
 ii = ii+jj;
end;
if (i_rpfe*i_d84) == 1;
 fprintf('rpfe*i_d84 = ');
 jj = length(nlags_rpfe);
 tmp = bzero;
 tmp(ii+1:ii+jj) = ones(jj,1);
 fprintf('%11.4f %11.4f \n',[tmp'*bhat,sqrt(tmp'*vbeta*tmp)]);
 ii = ii+jj;
end;
if i_rpimp_np == 1;
 fprintf('rpimp_np = ');
 jj = length(nlags_rpimp_np);
 tmp = bzero;
 tmp(ii+1:ii+jj) = ones(jj,1);
 fprintf('%11.4f %11.4f \n',[tmp'*bhat,sqrt(tmp'*vbeta*tmp)]);
 ii = ii+jj;
end;

e_fs = Y_fs-X_fs*bhat;   % Full Sample Residuals

% Compute var(residual) over various subsamples
%
ser_fs = ser;
% 1960-89
ismpl = smpl(calvec,[1960,2],[1989,4],4);
e = e_fs(ismpl==1);
ser_60_89 = sqrt(mean(e.^2));
% 2007:q4 - 2013:q3
ismpl = smpl(calvec,[2007,4],[2013,3],4);
e = e_fs(ismpl==1);
ser_07_13 = sqrt(mean(e.^2));
% 1990:q1 - 2013:q3
ismpl = smpl(calvec,[1990,1],[2013,3],4);
e = e_fs(ismpl==1);
ser_90_13 = sqrt(mean(e.^2));

fprintf('ser full 60-13 =');
fprintf('%6.2f \n',ser_fs);
fprintf('ser full 60-89 =');
fprintf('%6.2f \n',ser_60_89);
fprintf('ser full 90-13 =');
fprintf('%6.2f \n',ser_90_13);
fprintf('ser full 07-13 =');
fprintf('%6.2f \n',ser_07_13);

% Compute residual variance using rolling moving average
var_e_ma = NaN*zeros(dnobs,1);
for t = 1:dnobs;
    t1 = max([1,t-nma_var_pi]);
    t2 = min([dnobs,t+nma_var_pi]);
    tmp = packr(e_fs(t1:t2));
    if length(tmp) >= nma_var_pi;
        var_e_ma(t) = mean(tmp.^2);
    end;
end;

% Compute NAIRU -- Set initial value at BP value in first period
ismpl= smpl(calvec,nfirst_pcest,nfirst_pcest,4);
ubar = utrend(ismpl==1);
ismpl = smpl(calvec,nfirst_pcest,nlast_pcest,4);
ugap_cf = urate-ubar;

% Compute X Using this ugap measure 
X_cf = NaN*zeros(dnobs,size(X_fs,2));
X_cf(:,length(nlags_ugap)+1:end) = X_fs(:,length(nlags_ugap)+1:end);
for i = 1:length(nlags_ugap);
    X_cf(:,i) = lag(ugap_cf,nlags_ugap(i));
end;

% Errors assuming NAIRU is fixed at initial value
e_cf = Y_fs - X_cf*bhat;
ismpl = smpl(calvec,nfirst_pcest,nlast_pcest,4);
z = e_cf(ismpl==1);
cal = calvec(ismpl==1);
rvec = var_e_ma(ismpl==1);
t = length(cal);
u = urate(ismpl==1);

% Compute Estimated NAIRU
% Carry out signal extraction -- brute force calculation (not recursive)
init_se = 3;    % Standard deviation for initial condition P(0/0)
var_init = init_se*init_se*ones(t,t);
var_v = (sigma_delta_ubar*b_ugap)^2;
R = diag(rvec);          % Noise covariance matrix (ind. but hetero)
lambda_vec = sqrt(var_v./rvec);
tmp = tril(ones(t,t));
Q = var_v*tmp*tmp';      % Random Walk Covariance matrix
Q = Q + var_init;        % Add in initial condition
Var_Z = Q + R;
Var_Z_inv = inv(Var_Z);
K = Q*Var_Z_inv;
what = K*z;
var_w = Q - K*Q';
uhat = -what/b_ugap;
var_uhat = var_w/(b_ugap^2);
nairu = uhat+ubar;
se_nairu = sqrt(diag(var_uhat));
fprintf('NAIRU Results using the following parameter values \n');
%fprintf('sqrt(R) = %4.2f \n',sqrt_r);
fprintf('sigma_delta_ubar = %5.3f \n',sigma_delta_ubar);
%fprintf('Date,error,urate,ubar,se_ubar,lambda \n');
%[cal/100,z,u,uhat+ubar,sqrt(diag(var_uhat)),lambda_vec]
%
% Compute Change, from 2007:3 through 2013,4
i1 = smpl(cal,[2007,3],[2007,3],4);
i2 = smpl(cal,[2013,3],[2013,3],4);
i2 = smpl(cal,[2013,3],[2013,3],4);
d = i2-i1;
uchange = d'*uhat;
se_uchange = sqrt(d'*var_uhat*d);
fprintf('change 2007:Q3 - 2013:Q3 \n');
fprintf('%6.2f %6.2f \n',uchange,se_uchange);


% Print out values at Particular Dates
ismpl3 = smpl(cal,[2007,3],[2007,3],4);
ismpl4 = smpl(cal,[2010,3],[2010,3],4);
ismpl5 = smpl(cal,[2013,3],[2013,3],4);
ismpl = ismpl3+ismpl4+ismpl5;
uchange = u(ismpl5==1)-u(ismpl3==1);
tmp = [cal/100,u,nairu,se_nairu,lambda_vec];
tmp = tmp(ismpl==1,:);
for i = 1:size(tmp,1);
 fprintf('%6.3f %6.2f %6.2f %6.2f %6.2f \n',tmp(i,1),tmp(i,2),tmp(i,3),tmp(i,4), tmp(i,5));
end;

[nairu_min,imin] = min(nairu);
[nairu_max,imax] = max(nairu);
fprintf(' Nairu min = ');
fprintf('%6.3f %6.2f \n',cal(imin),nairu(imin));
fprintf('Nairu max = ');
fprintf('%6.3f %6.2f \n',cal(imax),nairu(imax));

[u_min,imin] = min(u);
[u_max,imax] = max(u);
fprintf(' u min = ');
fprintf('%6.3f %6.2f \n',cal(imin),u(imin));
fprintf('u max = ');
fprintf('%6.3f %6.2f \n',cal(imax),u(imax));
fprintf('change in u 2007:Q3 - 2013:Q3 \n');
fprintf('%6.2f \n', uchange);

% Compute Ugap using estimated Nairu
ismpl = smpl(calvec,nfirst_pcest,nlast_pcest,4);
nairu_fs = NaN*zeros(dnobs,1);
nairu_fs(ismpl==1) = nairu;
ugap_nairu = urate-nairu_fs;

% Compute Using this ugap measure 
X_nairu = NaN*zeros(dnobs,size(X_fs,2));
X_nairu(:,length(nlags_ugap)+1:end) = X_fs(:,length(nlags_ugap)+1:end);
for i = 1:length(nlags_ugap);
    X_nairu(:,i) = lag(ugap_nairu,nlags_ugap(i));
end;
e_nairu = Y_fs - X_nairu*bhat;

% Compute UGAP with no change in Nairu 
ismpl = smpl(calvec,n_initial,n_initial,4);
nairu_initial = nairu_fs(ismpl==1);
nairu_unchanged = nairu_fs;
ismpl = smpl(calvec,nfirst_cf,nlast_cf,4);
nairu_unchanged(ismpl==1) = nairu_initial;
ugap_unchanged = urate-nairu_unchanged;
X_nairu_unchanged = NaN*zeros(dnobs,size(X_fs,2));
X_nairu_unchanged(:,length(nlags_ugap)+1:end) = X_fs(:,length(nlags_ugap)+1:end);
for i = 1:length(nlags_ugap);
    X_nairu_unchanged(:,i) = lag(ugap_unchanged,nlags_ugap(i));
end;

% Carry out counterfactual using these theta values
if i_theta == 0;
    theta_cf = theta_7985;
end;
if i_theta == 1;
    theta_cf = theta_0713;
end;
b_cf = bhat;
if i_z == 1;
    ncontrols = length(bhat)-length(nlags_ugap);
    b_cf(end-ncontrols+1:end)=zeros(ncontrols,1);
end;
if i_nairu == 0;
    X_cf = X_nairu;
end;
if i_nairu == 1;
    X_cf = X_nairu_unchanged;
end;
xfit = X_cf*b_cf+e_nairu;
yfit = NaN*zeros(dnobs,1);
[aa,tfirst] = max(smpl(calvec,nfirst_cf,nfirst_cf,4));
[aa,tlast] = max(smpl(calvec,nlast_cf,nlast_cf,4));

dp_lag = dp(tfirst-1);
for t = tfirst:tlast;
    yfit(t) = dp_lag + xfit(t) - theta_cf*xfit(t-1);
    dp_lag = yfit(t);
end;
% Compute Average value in 2013
ismpl = smpl(calvec,n_avg_first,n_avg_last,4);
avg_dp = mean(dp(ismpl==1));
avg_cf = mean(yfit(ismpl==1));
fprintf('Acutal and Counterfactual average values of inflation: \n ');
fprintf('%5.1f %5.1f \n',avg_dp,avg_cf);


