% plot theta
%   Load and plot
%   (d) MA Coefficient

clear all;
small = 1.0e-10;
big = 1.0e+6;                  
% -- File Directories 
outdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/out/';
figdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/fig/';
matdir = '/Users/mwatson/Dropbox/ASSA14/ddisk/matlab/mat/';

% -- Read in Data 
load_data = 0;  % 1 if reloading data from Excel, etc 
data_assa;

% Inflation Series 
pstr = 'd_p_pce_lfe';
eval(['dp = ' pstr ';']);
p = p_pce_lfe;
% Load Results computed previously
str_tmp = [matdir pstr '_theta_pct'];
load(str_tmp);

% Graph Theta
s = theta_pct(:,4);
s_u = theta_pct(:,6);
s_l = theta_pct(:,2);
axis([1960 2015 0 1]);  % Set axis (v(3) and v(4) are the verticl axis)
str_temp = 'Theta';
save_g_str = [figdir str_temp '.jpg'];
xlabel('Date','FontSize',12,'FontWeight','normal','Color','k'); 
%ylabel('Y-Value','FontSize',12,'FontWeight','normal','Color','k');
hold on;
 plot(calvec,s,'- k','LineWidth',1);
 plot(calvec,s_u,': r','LineWidth',1);
 plot(calvec,s_l,': r','LineWidth',1);
hold off;
legend('Median','90th Percentile','10th Percentile');
legend('Location','NorthWest');
saveas(gcf,save_g_str);






