proc (7)=kfilt_llf(y,x1,p1,h,f,r,q);

@ Kalman Filter Procedure  -- Hamilton Notation
  y(t) = h'x(t) + w(t)
  x(t) = F x(t-1) + v(t)

  var(w(t)) = r;
  var(v(t)) = q;

  x1 = x(t-1/t-1)  -- on input
  p1 = p(t-1/t-1)  -- on input
  
  Output includes innovations, variance of innovations and log-likelihood;
@
local x2, p2, e, k, ht, hti, llf;

x2=f*x1;
e=y-h'x2;
p2=f*p1*f'+ q;
ht=h'p2*h + r;
hti=invpd(ht);
k=p2*h*(invpd(ht));
x1=x2+k*e;
p1=(eye(rows(p1))-k*h')*p2;
@ Correct any small round-off problems @
p1=0.5*(p1+p1');

@ Compute log-likelihood @
llf=-0.5*(ln(det(ht))+(e'hti*e));

retp(x1,p1,x2,p2,e,ht,llf);

endp;

