proc(1) = gordn82q(tdsq);

/* -- Compute the Variable "Gordon82"
     to model effect of Nixon wage and price controls 
     this is a quatertly series

     Series values:
    
     -- monthly -- 
     0.8 from 1971:7-1972:9
    -0.4 from 1974:4-1974:6
    -1.6 from 1974:7-1974:12
    -0.4 from 1975:1-1975:3

     -- quarterly -- 
     0.8 from 1971:3-1972:3
    -0.4 from 1974:2-1974:2
    -1.6 from 1974:3-1974:4
    -0.4 from 1975:1-1975:1  
*/



local d1, d2, d3, d4, eps, i1, i2, i3, i4,f1,f2,f3,f4, gdn82;
d1=1971+(3-1)/4; f1=1972+(3-1)/4;
d2=1974+(2-1)/4; f2=1974+(2-1)/4;
d3=1974+(3-1)/4; f3=1974+(4-1)/4;
d4=1975+(1-1)/4; f4=1975+(1-1)/4;

eps=.0001;
i1= (tdsq .>= d1-eps) .and (tdsq .< f1+eps);    
i2= (tdsq .>= d2-eps) .and (tdsq .< f2+eps);    
i3= (tdsq .>= d3-eps) .and (tdsq .< f3+eps);    
i4= (tdsq .>= d4-eps) .and (tdsq .< f4+eps);    

gdn82= (0.8*i1) + (-.4*i2) + (-1.6*i3) + (-.4*i4);

retp(gdn82);

endp;