/********************************************************************
* FIG10.G :
*
* PROGRAM TO GRAPH Response to oil shock for various periods
*
* Last program update: 4/27/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps= 24;
ymx = .15;
ymn = -.15;
ystp = .05;
pmx = .1;
pmn = -.1;
pstp = .05;
fmx = 40;
fmn = -20;
fstp = 10;


load data1[nsteps,2] = c:f10p1_y.dta;
load data2[nsteps,2] = c:f10p1_p.dta;
load data3[nsteps,2] = c:f10p1_ff.dta;

load data4[nsteps,2] = c:f10p2_y.dta;
load data5[nsteps,2] = c:f10p2_p.dta;
load data6[nsteps,2] = c:f10p2_ff.dta;

load data7[nsteps,2] = c:f10p3_y.dta;
load data8[nsteps,2] = c:f10p3_p.dta;
load data9[nsteps,2] = c:f10p3_ff.dta;

load data10[nsteps,2] = c:f10p4_y.dta;
load data11[nsteps,2] = c:f10p4_p.dta;
load data12[nsteps,2] = c:f10p4_ff.dta;


data1 = 100.*data1;
data2 = 100.*data2;
data3 = 100.*data3;
data4 = 100.*data4;
data5 = 100.*data5;
data6 = 100.*data6;
data7 = 100.*data7;
data8 = 100.*data8;
data9 = 100.*data9;
data10 = 100.*data10;
data11 = 100.*data11;
data12 = 100.*data12;


/* Order is mean and standard deviation by column */
/* Order of periods is:
1= 66-95
2= 66-75
3= 76-85
4= 86-95
*/

output file = c:fig10g.out reset;
output on;

/********************************************************************
* GRAPH
********************************************************************/
axhght = .3;
axht = .35;

begwind;

xsize = (9/3) - .55;
ysize = (6.855/3)-.75;
marg = 1.25;
botmarg = 0;

makewind(xsize,ysize,marg,botmarg+3*ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+3*ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+3*ysize,1);

makewind(xsize,ysize,marg,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+2*ysize,1);

makewind(xsize,ysize,marg,botmarg+ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+ysize,1);

makewind(xsize,ysize,marg,botmarg,1);
makewind(xsize,ysize,marg+xsize,botmarg,1);
makewind(xsize,ysize,marg+2*xsize,botmarg,1);

x = seqa(0,1,nsteps);
z = zeros(nsteps,1);

setwind(1);

ylabel("Percent");
_pmsgctl = (0~8.25~.75~0~2~15~5)|(4~7~.5~0~2~15~3)|
           (-3.5~7~.5~0~2~15~3)|(-3.5~4~.5~0~2~15~3);
str1 =
"Figure 10: Response to a 1 Percent Oil Price Shock";
str2 =
"\000Output";
str3 =
"\000Sample Period";
str4 =
"\0001966-95";

_pmsgstr = str1 $+ str2 $+ str3 $+ str4;

_paxht = axht;
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data1[.,1]~(data1[.,1]+data1[.,2])~(data1[.,1]-data1[.,2])~z);


setwind(2);
graphset;
ylabel("Percent");
_pmsgctl = (4~7~.5~0~2~15~3);
str1 =
"Prices";
_pmsgstr = str1;
_plwidth = (3|3|3|0);
_pltype = (6|1|1|6);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data2[.,1]~(data2[.,1]+data2[.,2])~(data2[.,1]-data2[.,2])~z);


setwind(3);
graphset;
ylabel("Basis Points");
_pmsgctl = (3~7~.5~0~2~15~3);
str1 =
"Federal Funds";
_pmsgstr = str1;
_plwidth = (3|3|3|0);
_pltype = (6|1|1|6);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data3[.,1]~(data3[.,1]+data3[.,2])~(data3[.,1]-data3[.,2])~z);


setwind(4);
graphset;
ylabel("Percent");
_pmsgctl = (-3.5~4~.5~0~2~15~3);
str1 =
"1966-75";
_pmsgstr = str1;
_plwidth = (3|3|3|0);
_pltype = (6|1|1|6);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data4[.,1]~(data4[.,1]+data4[.,2])~(data4[.,1]-data4[.,2])~z);


setwind(5);
graphset;
ylabel("Percent");
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
_paxht = axht;
xy(x,data5[.,1]~(data5[.,1]+data5[.,2])~(data5[.,1]-data5[.,2])~z);


setwind(6);
graphset;
ylabel("Basis Points");
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
_paxht = axht;
xy(x,data6[.,1]~(data6[.,1]+data6[.,2])~(data6[.,1]-data6[.,2])~z);


setwind(7);
graphset;
ylabel("Percent");
_pmsgctl = (-3.5~4~.5~0~2~15~3);
str1 =
"1976-85";
_pmsgstr = str1;
_plwidth = (3|3|3|0);
_pltype = (6|1|1|6);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data7[.,1]~(data7[.,1]+data7[.,2])~(data7[.,1]-data7[.,2])~z);


setwind(8);
graphset;
ylabel("Percent");
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
_paxht = axht;
xy(x,data8[.,1]~(data8[.,1]+data8[.,2])~(data8[.,1]-data8[.,2])~z);


setwind(9);
graphset;
ylabel("Basis Points");
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
_paxht = axht;
xy(x,data9[.,1]~(data9[.,1]+data9[.,2])~(data9[.,1]-data9[.,2])~z);


setwind(10);
graphset;
ylabel("Percent");
_pmsgctl = (-3.5~4~.5~0~2~15~3);
str1 =
"1986-95";
_pmsgstr = str1;
_plwidth = (3|3|3|0);
_pltype = (6|1|1|6);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data10[.,1]~(data10[.,1]+data10[.,2])~(data10[.,1]-data10[.,2])~z);


setwind(11);
graphset;
ylabel("Percent");
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data11[.,1]~(data11[.,1]+data11[.,2])~(data11[.,1]-data11[.,2])~z);


setwind(12);
graphset;
ylabel("Basis Points");
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
_paxht = axht;
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
_pnumht = axhght;
_pnum = {1,2,0};
xy(x,data12[.,1]~(data12[.,1]+data12[.,2])~(data12[.,1]-data12[.,2])~z);


endwind;

output off;
end;

