/********************************************************************
* FIG2.G :
*
* PROGRAM TO GRAPH Response to oil shock for various measures of oil
*
* Only graphs: nominal price level, hp, mork, hamilton
*
* Last program update: 4/29/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps=48;
ymx = .1;
ymn = -.1;
ystp = .05;
pmx = .1;
pmn = -.1;
pstp = .05;
fmx = 20;
fmn = -15;
fstp = 35/4;


load data1[nsteps,2] = c:f2o1_y.dta;
load data2[nsteps,2] = c:f2o1_p.dta;
load data3[nsteps,2] = c:f2o1_ff.dta;

load data4[nsteps,2] = c:f2o2_y.dta;
load data5[nsteps,2] = c:f2o2_p.dta;
load data6[nsteps,2] = c:f2o2_ff.dta;

load data7[nsteps,2] = c:f2o3_y.dta;
load data8[nsteps,2] = c:f2o3_p.dta;
load data9[nsteps,2] = c:f2o3_ff.dta;

load data10[nsteps,2] = c:f2o4_y.dta;
load data11[nsteps,2] = c:f2o4_p.dta;
load data12[nsteps,2] = c:f2o4_ff.dta;

load data13[nsteps,2] = c:f2o5_y.dta;
load data14[nsteps,2] = c:f2o5_p.dta;
load data15[nsteps,2] = c:f2o5_ff.dta;

load data16[nsteps,2] = c:f2o6_y.dta;
load data17[nsteps,2] = c:f2o6_p.dta;
load data18[nsteps,2] = c:f2o6_ff.dta;

load data19[nsteps,2] = c:f2o7_y.dta;
load data20[nsteps,2] = c:f2o7_p.dta;
load data21[nsteps,2] = c:f2o7_ff.dta;


/*
load data22[nsteps,2] = c:f2o8_y.dta;
load data23[nsteps,2] = c:f2o8_p.dta;
load data24[nsteps,2] = c:f2o8_ff.dta;
*/

data1 = 100.*data1;
data2 = 100.*data2;
data3 = 100.*data3;
data4 = 100.*data4;
data5 = 100.*data5;
data6 = 100.*data6;
data7 = 100.*data7;
data8 = 100.*data8;
data9 = 100.*data9;
data10 = 100.*data10;
data11 = 100.*data11;
data12 = 100.*data12;
data13 = 100.*data13;
data14 = 100.*data14;
data15 = 100.*data15;
data16 = 100.*data16;
data17 = 100.*data17;
data18 = 100.*data18;
data19 = 100.*data19;
data20 = 100.*data20;
data21 = 100.*data21;

/*
data22 = 100.*data22;
data23 = 100.*data23;
data24 = 100.*data24;
*/

/* Order is mean and standard deviation by column */
/* Order of oil variables is:
1= Log of Relative Price
2= Hamilton
3= Change if log of relative price
4= Change in log of nominal price
5= Mork
6= Rotemberg-Woodford
7= Hoover-Perez
8 = Nordhaus (using Hamilton oil)
*/

output file = c:fig2g.out reset;
output on;

/********************************************************************
* GRAPH
********************************************************************/
begwind;

xsize = (9/3) - .6;
ysize = (6.855/4)-.25;
marg = 1.5;
botmarg = 0;

makewind(xsize,ysize,marg,botmarg+3*ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+3*ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+3*ysize,1);

makewind(xsize,ysize,marg,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+2*ysize,1);

makewind(xsize,ysize,marg,botmarg+ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+ysize,1);

makewind(xsize,ysize,marg,botmarg,1);
makewind(xsize,ysize,marg+xsize,botmarg,1);
makewind(xsize,ysize,marg+2*xsize,botmarg,1);

x = seqa(0,1,nsteps);
z = zeros(nsteps,1);

setwind(1);

ylabel("Percent");
margin(.1,0,0,0);
_pmsgctl = (-2~8.75~.75~0~2~15~5)|(4~7~.5~0~2~15~3)|
           (-5.5~7~.5~0~2~15~3)|(-5.5~4~.5~0~2~15~3);
_paxht = .35;
_pnumht = .23;

str1 =
"Figure 2: Response to a 1 Percent Oil Price Shock";
str2 =
"\000Output";
str3 =
"\000Oil Measure";
str4 =
"\000Nominal Oil Price";
_pnum = {1,2,0};
_pmsgstr = str1 $+ str2 $+ str3 $+ str4;
_pltype = (6|1|1|6);
_plwidth = (3|3|3|0);
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
xy(x,data16[.,1]~(data16[.,1]+data16[.,2])~(data16[.,1]-data16[.,2])~z);


setwind(2);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pmsgctl = (4~7~.5~0~2~15~3);
str1 =
"Prices";
_pmsgstr = str1;

_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
xy(x,data17[.,1]~(data17[.,1]+data17[.,2])~(data17[.,1]-data17[.,2])~z);


setwind(3);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
ylabel("Basis Points");
_paxht = .35;
_pnumht = .23;
_pmsgctl = (3~7~.5~0~2~15~3);
str1 =
"Federal Funds";
_pmsgstr = str1;

_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
xy(x,data18[.,1]~(data18[.,1]+data18[.,2])~(data18[.,1]-data18[.,2])~z);

setwind(4);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pmsgctl = (-5.5~4~.5~0~2~15~3);
str1 =
"Hoover-Perez";
_pmsgstr = str1;

_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
xy(x,data19[.,1]~(data19[.,1]+data19[.,2])~(data19[.,1]-data19[.,2])~z);


setwind(5);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
xy(x,data20[.,1]~(data20[.,1]+data20[.,2])~(data20[.,1]-data20[.,2])~z);


setwind(6);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Basis Points");
_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
xy(x,data21[.,1]~(data21[.,1]+data21[.,2])~(data21[.,1]-data21[.,2])~z);


setwind(7);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pmsgctl = (-5.5~4~.5~0~2~15~3);
str1 =
"Mork";
_pmsgstr = str1;

_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
xy(x,data13[.,1]~(data13[.,1]+data13[.,2])~(data13[.,1]-data13[.,2])~z);


setwind(8);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
xy(x,data14[.,1]~(data14[.,1]+data14[.,2])~(data14[.,1]-data14[.,2])~z);


setwind(9);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Basis Points");
_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
xy(x,data15[.,1]~(data15[.,1]+data15[.,2])~(data15[.,1]-data15[.,2])~z);


setwind(10);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pmsgctl = (-5.5~4~.5~0~2~15~3);
str1 =
"Hamilton";
_pmsgstr = str1;

_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(ymn,ymx,ystp,0);
xy(x,data4[.,1]~(data4[.,1]+data4[.,2])~(data4[.,1]-data4[.,2])~z);


setwind(11);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Percent");
_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(pmn,pmx,pstp,0);
xy(x,data5[.,1]~(data5[.,1]+data5[.,2])~(data5[.,1]-data5[.,2])~z);


setwind(12);
graphset;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = .35;
_pnumht = .23;
ylabel("Basis Points");
_pltype = (6|1|1|6);
xtics(0,nsteps,12,0);
ytics(fmn,fmx,fstp,0);
xy(x,data6[.,1]~(data6[.,1]+data6[.,2])~(data6[.,1]-data6[.,2])~z);


endwind;

output off;
end;

