/********************************************************************
* FIG3.G :
*
* PROGRAM TO GRAPH MONEY SHOCK W/ STANDARD ERRORS
*
* Last program update: 4/28/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps = 48;

load data1[nsteps,5] = c:f3_fa.dta;
load data2[nsteps,4] = c:f3_fb.dta;
load data3[nsteps,5] = c:f3_sa.dta;
load data4[nsteps,4] = c:f3_sb.dta;

output file = c:fig3g.out reset;
output on;

/********************************************************************
* GRAPH
********************************************************************/
axhght = .23;
titht = .4;
axht = .35;

begwind;

_pmsgctl = (.25~8~.5~0~2~15~5);
_pmsgstr =
"Figure 3: Responses to a Monetary Policy Shock in 7 Variable System";
_pltype = (6|1|1|6);
xtics(0,nsteps,6,0);

z = zeros(nsteps,1);

xsize = (9/3) - .25;
ysize = (6.855/3) - .25;
makewind(xsize,ysize,0,2*ysize,1);
makewind(xsize,ysize,xsize,2*ysize,1);
makewind(xsize,ysize,2*xsize,2*ysize,1);
makewind(xsize,ysize,0,ysize,1);
makewind(xsize,ysize,xsize,ysize,1);
makewind(xsize,ysize,2*xsize,ysize,1);
makewind(xsize,ysize,0,0,1);
makewind(xsize,ysize,xsize,0,1);
makewind(xsize,ysize,2*xsize,0,1);

x = seqa(0,1,nsteps);

setwind(1);
_pnumht = axhght;
_ptitlht = titht;
_plwidth = (3|3|3|0);
_pnum = {1,2,0};
_paxht = axht;
ylabel("Percent");
ytics(-.12,.08,.2/4,0);
title("\201Output");
xy(x,100*data1[.,1]~(100*data1[.,1]+100*data3[.,1])~
(100*data1[.,1]-100*data3[.,1])~z);

setwind(2);
graphset;
_pltype = (6|1|1|6);
_pnumht = axhght;
_pnum = {1,2,0};
_ptitlht = titht;
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Percent");

ytics(-.16,.04,.2/4,0);
xtics(0,nsteps,6,0);
title("\201Prices");
xy(x,100*data1[.,2]~(100*data1[.,2]+100*data3[.,2])~
(100*data1[.,2]-100*data3[.,2])~z);

setwind(3);
_pnumht = axhght;
_pnum = {1,2,0};
_ptitlht = titht;
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Percent");

ytics(-.7,.1,.8/4,0);
title("\201Commodity Prices");
xy(x,100*data1[.,3]~(100*data1[.,3]+100*data3[.,3])~
(100*data1[.,3]-100*data3[.,3])~z);

setwind(4);
_pnum = {1,2,0};
_pnumht = axhght;
_ptitlht = titht;
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Percent");

ytics(-.12,.2,.32/4,0);
title("\201Oil");
xy(x,100*data1[.,4]~(100*data1[.,4]+100*data3[.,4])~
(100*data1[.,4]-100*data3[.,4])~z);

setwind(5);
_pnumht = axhght;
_pnum = {1,2,0};
_ptitlht = titht;
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Basis Points");

ytics(-35,35,70/4,0);
title("\201Fed Funds");
xy(x,100*data1[.,5]~(100*data1[.,5]+100*data3[.,5])~(100*data1[.,5]-100*data3[.,
5])~z);

setwind(8);
_pnumht = axhght;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_ptitlht = titht;
_paxht = axht;
ylabel("Basis Points");

title("\201Short Rate");
xy(x,100*data2[.,1]~(100*data2[.,1]+100*data4[.,1])~(100*data2[.,1]-100*data4[.,
1])~z);

setwind(9);
_pnumht = axhght;
_pnum = {1,2,0};
_ptitlht = titht;
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Long Rate");
xy(x,100*data2[.,2]~(100*data2[.,2]+100*data4[.,2])~(100*data2[.,2]-100*data4[.,
2])~z);

setwind(6);
_pnumht = axhght;
_pnum = {1,2,0};
_ptitlht = titht;
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Short Rate Term Premium");
xy(x,100*data2[.,3]~(100*data2[.,3]+100*data4[.,3])~(100*data2[.,3]-100*data4[.,
3])~z);

setwind(7);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (3|3|3|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Long Rate Term Premium");
xy(x,100*data2[.,4]~(100*data2[.,4]+100*data4[.,4])~(100*data2[.,4]-100*data4[.,
4])~z);


endwind;

output off;
end;

