/********************************************************************
* FIG4.G :
*
* PROGRAM TO GRAPH OIL SHOCK
*
* Last program update: 4/10/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps = 48;

load data1[nsteps,4] = c:fig4a.dta;
load data2[nsteps,4] = c:fig4b.dta;
load data3[nsteps,4] = c:fig4c.dta;
load data4[nsteps,4] = c:fig4d.dta;
load data5[nsteps,3] = c:fig4e.dta;

data = data1~data2~data3~data4~data5;

output file = c:fig4g.out reset;
output on;

/********************************************************************
* GRAPH
********************************************************************/
/* Global Variables for Graphing */
axhght = .23;
titht = .4;
axht = .35;

begwind;

_pmsgctl = (.25~8~.5~0~2~15~5);
_pmsgstr =
"Figure 4: Responses to an Oil Shock (Hamilton) in 7 Variable Systems";
_pltype = (6|1|6|6);
xtics(0,nsteps,6,0);

z = zeros(nsteps,1);

xsize = (9/3) - .25;
ysize = (6.855/3) - .25;
makewind(xsize,ysize,0,2*ysize,1);
makewind(xsize,ysize,xsize,2*ysize,1);
makewind(xsize,ysize,2*xsize,2*ysize,1);
makewind(xsize,ysize,0,ysize,1);
makewind(xsize,ysize,xsize,ysize,1);
makewind(xsize,ysize,2*xsize,ysize,1);
makewind(xsize,ysize,0,0,1);

x = seqa(0,1,nsteps);

setwind(1);
_ptitlht = titht;
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Percent");

ytics(-.025,.02,(.02+.025)/4,0);
title("\201Output");
xy(x,100*data[.,1]~100*data[.,8]~100*data[.,14]~z);

setwind(2);
graphset;
_ptitlht = titht;
_pltype = (6|1|6|6);
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Percent");

ytics(-.01,.05,(.05+.01)/4,0);
xtics(0,nsteps,6,0);
title("\201Prices");
xy(x,100*data[.,2]~100*data[.,9]~100*data[.,15]~z);

setwind(3);
_ptitlht = titht;
_pltype = (6|1|6|6);
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Percent");

ytics(-.12,.16,(.16+.12)/4,0);
title("\201Commodity Prices");
xy(x,100*data[.,3]~100*data[.,10]~100*data[.,16]~z);

setwind(4);
_ptitlht = titht;
_pltype = (6|1|6|6);
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Percent");

ytics(-.2,1,(1.2)/4,0);
title("\201Oil");
xy(x,100*data[.,4]~100*data[.,11]~100*data[.,17]~z);

setwind(5);
_ptitlht = titht;
_pltype = (6|1|6|6);
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Basis Points");

ytics(-2,8,10/4,0);
title("\201Fed Funds");
_plegctl = { 2 9 11 -4};
_plegstr = "Base\000Sims-Zha\000AP\000";
xy(x,100*data[.,5]~z~z);

setwind(6);
graphset;
_ptitlht = titht;
_pltype = (6|1|6|6);
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Basis Points");

ytics(-6,8,(8+6)/4,0);
xtics(0,nsteps,6,0);
title("\201Short Rate");
xy(x,100*data[.,6]~100*data[.,12]~100*data[.,18]~z);

setwind(7);
_ptitlht = titht;
_pltype = (6|1|6|6);
_pnumht = axhght;
_plwidth = (2|2|6|0);
_pnum = { 1, 2 ,0};
_paxht = axht;
ylabel("Basis Points");

ytics(-4,3,7/4,0);
title("\201Long Rate");
xy(x,100*data[.,7]~100*data[.,13]~100*data[.,19]~z);

endwind;

output off;
end;

