/********************************************************************
* FIG5.G :
*
* PROGRAM TO GRAPH OIL SHOCK w/ No Term Premium Response
*
* Last program update: 4/10/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps = 48;

load data1[nsteps,4] = c:fig5a.dta;
load data2[nsteps,4] = c:fig5b.dta;
load data3[nsteps,4] = c:fig5c.dta;
load data4[nsteps,4] = c:fig5d.dta;
load data5[nsteps,3] = c:fig5e.dta;

data = data1~data2~data3~data4~data5;

output file = c:fig5g.out reset;
output on;

/********************************************************************
* GRAPH
********************************************************************/
axhght = .23;
titht = .4;
axht = .35;

begwind;

_pmsgctl = (.25~8.25~.5~0~2~15~5)|(9.75~7.25~.4~0~2~15~5);
str1 =
"Figure 5: Responses to an Oil Shock (Hamilton) in 7 Variable Systems";
str2 = "\000No Term Premium Response";
_pmsgstr = str1 $+ str2;
_plwidth = (2|6|0|0);
_pltype = (6|6|6|6);
xtics(0,nsteps,6,0);

z = zeros(nsteps,1);

xsize = (9/3) - .25;
ysize = (6.855/3) - .25;
makewind(xsize,ysize,0,2*ysize,1);
makewind(xsize,ysize,xsize,2*ysize,1);
makewind(xsize,ysize,2*xsize,2*ysize,1);
makewind(xsize,ysize,0,ysize,1);
makewind(xsize,ysize,xsize,ysize,1);
makewind(xsize,ysize,2*xsize,ysize,1);
makewind(xsize,ysize,0,0,1);

x = seqa(0,1,nsteps);

setwind(1);
_pnumht = axhght;
_ptitlht = titht;
ytics(-.025,.02,(.02+.025)/4,0);
_pnum = {1,2,0};
_paxht = axht;
ylabel("Percent");

title("\201Output");
xy(x,100*data[.,1]~100*data[.,14]~z);

setwind(2);
graphset;
_pnumht = axhght;
_ptitlht = titht;
ytics(-.01,.03,.04/4,0);
_pnum = {1,2,0};
_plwidth = (2|6|0|0);
_pltype = (6|6|6|6);
_paxht = axht;
ylabel("Percent");
xtics(0,nsteps,6,0);
title("\201Prices");
xy(x,100*data[.,2]~100*data[.,15]~z);

setwind(3);
_pnumht = axhght;
_ptitlht = titht;
ytics(-.12,.12,.24/4,0);
_pnum = {1,2,0};
_plwidth = (2|6|0|0);
_paxht = axht;
ylabel("Percent");

title("\201Commodity Prices");
xy(x,100*data[.,3]~100*data[.,16]~z);

setwind(4);
_pnumht = axhght;
_ptitlht = titht;
ytics(-.2,1,1.2/4,0);
_pnum = {1,2,0};
_plwidth = (2|6|0|0);
_paxht = axht;
ylabel("Percent");

title("\201Oil");
xy(x,100*data[.,4]~100*data[.,17]~z);

setwind(5);
_pnumht = axhght;
_ptitlht = titht;
ytics(-2,8,10/4,0);
_pnum = {1,2,0};
_plwidth = (2|6|0|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Fed Funds");
_plegctl = { 2 9 11 -4};
_plegstr = "Base\000AP\000";
xy(x,100*data[.,5]~z);

setwind(6);
graphset;
_pnumht = axhght;
_ptitlht = titht;
ytics(-1,6,7/4,0);
_pnum = {1,2,0};
_plwidth = (2|6|0|0);
_pltype = (6|6|6|6);
_paxht = axht;
ylabel("Basis Points");

xtics(0,nsteps,6,0);
title("\201Short Rate");
xy(x,100*data[.,6]~100*data[.,18]);

setwind(7);
_pnumht = axhght;
_ptitlht = titht;
ytics(0,2.4,2.4/4,0);
_pnum = {1,2,0};
_plwidth = (2|6|0|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Long Rate");
xy(x,100*data[.,7]~100*data[.,19]);

endwind;

output off;
end;

