/********************************************************************
* FIG6.G :
*
* PROGRAM TO GRAPH OPEC Simulations
*
* Last program update: 4/10/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps=60;
load data1[nsteps,3] = c:fig6a.dta;
load data2[nsteps,3] = c:fig6b.dta;
load data3[nsteps,3] = c:fig6c.dta;
load data4[nsteps,3] = c:fig6d.dta;
load data5[nsteps,3] = c:fig6e.dta;
load data6[nsteps,3] = c:fig6f.dta;
load data7[nsteps,3] = c:fig6g.dta;
load data8[nsteps,3] = c:fig6h.dta;
load data9[nsteps,3] = c:fig6i.dta;

data = data1~data2~data3~data4~data5~data6~data7~data8~data9;

/* Order is output,prices,ff w/ each file ordered, endog,histor,exog */

output file = c:fig6g.out reset;
output on;

labs1=zeros(5,1);
labs2=zeros(5,1);
labs3=zeros(5,1);

labs1 = ftocv((72|73|74|75|76),2,0);
labs2 = ftocv((79|80|81|82|83),2,0);
labs3 = ftocv((88|89|90|91|92),2,0);

/********************************************************************
* GRAPH
********************************************************************/
axhght = .3;

begwind;

xsize = (9/3) - .5;
ysize = (6.855/3) - .5;
marg = 1;
botmarg = .8;

makewind(xsize,ysize,marg,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg,botmarg+ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg,botmarg,1);
makewind(xsize,ysize,marg+xsize,botmarg,1);
makewind(xsize,ysize,marg+2*xsize,botmarg,1);

x = seqa(1,1,nsteps);
z = zeros(nsteps,1);

setwind(1);

_pmsgctl = (1.5~8.25~.6~0~2~15~5)|(3.5~7~.4~0~2~15~3)|
                  (-3~7~.4~0~2~15~3)|(-3~4~.4~0~2~15~3);
str1 =
"Figure 6: Simulations of Historical Oil Price Shocks";
str2 =
"\000Output";
str3 =
"\000Sample Period";
str4 =
"\0001972-76";

_pnum = {1,2,0};
_pmsgstr = str1 $+ str2 $+ str3 $+ str4;
_pnumht = axhght;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs1,0);
xtics(1,nsteps,12,0);

ytics(-.06,.06,.12/4,0);
xy(x,data[.,1]~data[.,2]~data[.,3]);

setwind(2);
graphset;
ytics(3.45,3.85,(3.85-3.45)/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_pmsgctl = (3.5~7~.4~0~2~15~3);
str1 =
"Prices";
_pmsgstr = str1;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs1,0);
xtics(1,nsteps,12,0);
xy(x,data[.,4]~data[.,5]~data[.,6]);

setwind(3);
graphset;
ytics(2,14,4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_pmsgctl = (2.5~7~.4~0~2~15~3);
str1 =
"Federal Funds";
_pmsgstr = str1;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs1,0);
xtics(1,nsteps,12,0);

xy(x,data[.,7]~data[.,8]~data[.,9]);

setwind(4);
graphset;
ytics(-.08,.06,.14/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_pmsgctl = (-3~4~.4~0~2~15~3);
str1 =
"1979-83";
_pmsgstr = str1;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs2,0);
xtics(1,nsteps,12,0);

xy(x,data[.,10]~data[.,11]~data[.,12]);

setwind(5);
graphset;
ytics(3.95,4.35,(4.35-3.95)/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
asclabel(labs2,0);
xtics(1,nsteps,12,0);
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);

_plegctl = { 2 8 11.5 -9.8};
_plegstr = "FF Endogenous\000Historical\000FF Exogenous\000";
xy(x,data[.,13]~data[.,14]~data[.,15]);

setwind(6);
graphset;
ytics(6,20,14/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs2,0);
xtics(1,nsteps,12,0);
xy(x,data[.,16]~data[.,17]~data[.,18]);

setwind(7);
graphset;
ytics(-.03,.04,.07/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_pmsgctl = (-3~4~.4~0~2~15~3);
str1 =
"1988-92";
_pmsgstr = str1;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs3,0);
xtics(1,nsteps,12,0);

xy(x,data[.,19]~data[.,20]~data[.,21]);

setwind(8);
graphset;
ytics(4.4,4.68,(4.68-4.4)/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs3,0);
xtics(1,nsteps,12,0);

xy(x,data[.,22]~data[.,23]~data[.,24]);

setwind(9);
graphset;
ytics(2,11,13/4,0);
_pnum = {1,2,0};
_pnumht = axhght;
_plwidth = (6|2|2|0);
_pltype = (6|6|1|6);
asclabel(labs3,0);
xtics(1,nsteps,12,0);

xy(x,data[.,25]~data[.,26]~data[.,27]);

endwind;

output off;
end;

