/********************************************************************
* FIG7.G :
*
* PROGRAM TO GRAPH Response to oil shock for various sectors
*
* Last program update: 4/29/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps=48;

load data1a[nsteps,5] = c:s1a.dta;
load data2a[nsteps,5] = c:s1b.dta;
load data3a[nsteps,5] = c:s1c.dta;
load data4a[nsteps,2] = c:s1d.dta;

load data1b[nsteps,5] = c:s2a.dta;
load data2b[nsteps,5] = c:s2b.dta;
load data3b[nsteps,5] = c:s2c.dta;
load data4b[nsteps,2] = c:s2d.dta;

/* Order of oil variables is:
1= Log of Relative Price
2= Hamilton
3= Change if log of relative price
4= Change in log of nominal price
5= Mork
6= Rotemberg-Woodford
7= Hoover-Perez
8 = Nordhaus (using Hamilton oil)
*/

output file = c:fig7g.out reset;
output on;\

/********************************************************************
* GRAPH
********************************************************************/
begwind;

titht = .5;
axhght = .4;
xsize = (9/5) - .2;
ysize = (6.855/3)-.2;
marg = .25;
botmarg = 0;

makewind(xsize,ysize,marg,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+3*xsize,botmarg+2*ysize,1);
makewind(xsize,ysize,marg+4*xsize,botmarg+2*ysize,1);

makewind(xsize,ysize,marg,botmarg+ysize,1);
makewind(xsize,ysize,marg+xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg+2*xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg+3*xsize,botmarg+ysize,1);
makewind(xsize,ysize,marg+4*xsize,botmarg+ysize,1);

makewind(xsize,ysize,marg,botmarg,1);
makewind(xsize,ysize,marg+xsize,botmarg,1);
makewind(xsize,ysize,marg+2*xsize,botmarg,1);
makewind(xsize,ysize,marg+3*xsize,botmarg,1);
makewind(xsize,ysize,marg+4*xsize,botmarg,1);

x = seqa(0,1,nsteps);
z = zeros(nsteps,1);

setwind(1);
_pmsgctl = (.25~8.25~.8~0~2~15~5)|(9.5~7.5~.6~0~2~15~5);
_paxht = .35;
_ptitlht = titht;
_pnumht = axhght;
str1 =
"Figure 7: Sectoral Responses to Oil Price and Monetary Policy Shocks";
str2 =
"\000Solid=Monetary Policy Shock; Dashes=Oil Price Shock";
_pmsgstr = str1 $+ str2;
_pltype = (6|1|6);
_plwidth = (3|3|0);
_pnum = {1,2,0};
ytics(-.025,.02,.045/4,0);
xtics(0,nsteps,12,0);
title("\201Output");
xy(x,100*data1a[.,1]~100*data1b[.,1]~z);

setwind(2);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_pnumht = axhght;
_ptitlht = titht;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.03,.03,.06/4,0);
xtics(0,nsteps,12,0);
title("\201Prices");
xy(x,100*data1a[.,2]~100*data1b[.,2]~z);

setwind(3);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_ptitlht = titht;
_pnum = {1,2,0};
ytics(-.16,.12,.28/4,0);
xtics(0,nsteps,12,0);
title("\201Commodity Prices");
xy(x,100*data1a[.,3]~100*data1b[.,3]~z);

setwind(4);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_pnumht = axhght;
_ptitlht = titht;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.2,1,1.2/4,0);
xtics(0,nsteps,12,0);
title("\201Oil");
xy(x,100*data1a[.,4]~100*data1b[.,4]~z);

setwind(5);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_pnumht = axhght;
_ptitlht = titht;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-1,8,9/4,0);
xtics(0,nsteps,12,0);
title("\201Fed Funds");
xy(x,100*data1a[.,5]~100*data1b[.,5]~z);

setwind(6);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_pnumht = axhght;
_ptitlht = titht;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-1,6,7/4,0);
xtics(0,nsteps,12,0);
title("\201Short Rate");
xy(x,100*data2a[.,1]~100*data2b[.,1]~z);

setwind(7);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_pnumht = axhght;
_ptitlht = titht;
_pltype = (6|1|6);
ytics(-.6,3,3.6/4,0);
_pnum = {1,2,0};
xtics(0,nsteps,12,0);
title("\201Long Rate");
xy(x,100*data2a[.,2]~100*data2b[.,2]~z);

setwind(8);
graphset;
_plwidth = (3|3|0);
_paxht = .35;
_ptitlht = titht;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.026,.01,.036/4,0);
xtics(0,nsteps,12,0);
title("\201Consumption");
xy(x,100*data3a[.,3]~100*data3b[.,3]~z);

setwind(9);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.006,.006,.012/4,0);
xtics(0,nsteps,12,0);
title("\201PDE");
xy(x,100*data3a[.,5]~100*data3b[.,5]~z);

setwind(12);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.01,.004,.014/4,0);
xtics(0,nsteps,12,0);
title("\201Residential");
xy(x,100*data3a[.,4]~100*data3b[.,4]~z);


setwind(10);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.0016,.0016,.0032/4,0);
xtics(0,nsteps,12,0);
title("\201Structures");
xy(x,100*data4a[.,1]~100*data4b[.,1]~z);

setwind(11);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.022,.01,.032/4,0);
xtics(0,nsteps,12,0);
title("\201Inventories");
xy(x,100*data4a[.,2]~100*data4b[.,2]~z);

setwind(13);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.002,.014,.016/4,0);
xtics(0,nsteps,12,0);
title("\201Government");
xy(x,100*data3a[.,2]~100*data3b[.,2]~z);

setwind(14);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.006,.006,.012/4,0);
xtics(0,nsteps,12,0);
title("\201Exports");
xy(x,100*data2a[.,5]~100*data2b[.,5]~z);

setwind(15);
graphset;
_plwidth = (3|3|0);
_ptitlht = titht;
_paxht = .35;
_pnumht = axhght;
_pltype = (6|1|6);
_pnum = {1,2,0};
ytics(-.01,.004,.014/4,0);
xtics(0,nsteps,12,0);
title("\201Imports");
xy(x,100*data3a[.,1]~100*data3b[.,1]~z);

endwind;

output off;
end;

