/********************************************************************
* FIG9.G :
*
* PROGRAM TO GRAPH OUTPUT SHOCK w/ No Term Premium Response
*
*
* Last program update: 4/10/97
********************************************************************/

#lineson;
new;
library pgraph;
graphset;
_pdate ="";
fonts("simplex complex microb simgrma");

/********************************************************************
* INPUT DATA AND SETUP
********************************************************************/
nsteps = 48;

load data1[nsteps,4] = c:fig9a.dta;
load data2[nsteps,4] = c:fig9b.dta;
load data3[nsteps,4] = c:fig9c.dta;
load data4[nsteps,4] = c:fig9d.dta;
load data5[nsteps,3] = c:fig9e.dta;

data = data1~data2~data3~data4~data5;

scle = (.01)/data1[1,1]; /* Scaled for 1% shock */
data = scle*data;

output file = c:fig9g.out reset;
output on;

/********************************************************************
* GRAPH
********************************************************************/
axhght = .23;
titht = .4;
axht = .35;

begwind;

_pmsgctl = (1~8.25~.5~0~2~15~5)|(9.5~7.25~.4~0~2~15~5);
str1 =
"Figure 9: Responses to an Output Shock in 7 Variable Systems";
str2 = "\000No Term Premium Response";
_pmsgstr = str1 $+ str2;
_pltype = (6|1|6|6);
xtics(0,nsteps,6,0);

z = zeros(nsteps,1);

xsize = (9/3) - .25;
ysize = (6.855/3) - .25;
makewind(xsize,ysize,0,2*ysize,1);
makewind(xsize,ysize,xsize,2*ysize,1);
makewind(xsize,ysize,2*xsize,2*ysize,1);
makewind(xsize,ysize,0,ysize,1);
makewind(xsize,ysize,xsize,ysize,1);
makewind(xsize,ysize,2*xsize,ysize,1);
makewind(xsize,ysize,0,0,1);

x = seqa(0,1,nsteps);

setwind(1);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_paxht = axht;
ylabel("Percent");
ytics(-.4,1,1.4/4,0);
title("\201Output");
xy(x,100*data[.,1]~100*data[.,8]~100*data[.,14]~z);

setwind(2);
graphset;
ytics(-.2,1.4,1.6/4,0);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_pltype = (6|1|6|6);
_paxht = axht;
ylabel("Percent");

xtics(0,nsteps,6,0);
title("\201Prices");
xy(x,100*data[.,2]~100*data[.,9]~100*data[.,15]~z);

setwind(3);
ytics(-1,5,6/4,0);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_paxht = axht;
ylabel("Percent");

title("\201Commodity Prices");
xy(x,100*data[.,3]~100*data[.,10]~100*data[.,16]~z);

setwind(4);
ytics(-.4,.3,.7/4,0);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_paxht = axht;
ylabel("Percent");

title("\201Oil");
xy(x,100*data[.,4]~100*data[.,11]~100*data[.,17]~z);

setwind(5);
ytics(0,70,70/4,0);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Fed Funds");
_plegctl = { 2 9 11 -4};
_plegstr = "Base\000Sims-Zha\000AP\000";
xy(x,100*data[.,5]~z~z);

setwind(6);
graphset;
ytics(0,50,50/4,0);
_pltype = (6|1|6|6);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_paxht = axht;
ylabel("Basis Points");

xtics(0,nsteps,6,0);
title("\201Short Rate");
xy(x,100*data[.,6]~100*data[.,12]~100*data[.,18]);

setwind(7);
ytics(0,28,28/4,0);
_pnumht = axhght;
_ptitlht = titht;
_pnum = {1,2,0};
_plwidth = (2|2|6|0);
_paxht = axht;
ylabel("Basis Points");

title("\201Long Rate");
xy(x,100*data[.,7]~100*data[.,13]~100*data[.,19]);

endwind;

output off;
end;

