proc(3)=bdatain(sx,sy,missc,tobs,ismpl);
/* bdatain.prc, 5/29/92, mww
   This proc reads in data from files sx and sy.
   It eliminates data in both x and y when data on either one is missing.
   Input:
         sx = string with file name for series x
         sy = string with file name for series y
         missc = missing value code
         tobs = total number of obs in series
   Output
          x = series x output
          y = series y output
         ii = indicator of data locations;
*/
local x, y, ix, iy, ii;

load x[tobs,1]=^sx;
load y[tobs,1]=^sy;
ix = x .ne missc;
iy = y .ne missc;
ii=ix.*iy.*ismpl;
x=selif(x,ii);
y=selif(y,ii);

retp(x,y,ii);
endp;
