@ gc.prc
 computes Granger-Causality Test for Autoregression
 -- test whether x2 GC yr conditional on x1
    Robust=0 -- Non Robust
    Robust=1 -- Heterosk. Robust
@
proc (2)=gc(y,x1,x2,robust);

local e0, x, ssr0, e1, ssr1, fstat, signif, xxi, xre, beta, vbeta;
if robust .== 0;
@ -- NonRobust F-Test -- @
 if rows(x1) .== 1;
  e0=y; x=x2;
 else;
  e0=y-x1*(invpd(x1'x1))*x1'y;
  x=x1~x2;
 endif;
 ssr0=e0'e0;
 e1=y-x*(invpd(x'x))*x'y;
 ssr1=e1'e1;
 fstat=(rows(y)-cols(x))*( (ssr0-ssr1)/ssr1 )/cols(x2);
 signif=cdffc(fstat,cols(x2),rows(y)-cols(x));
endif;

if robust .== 1;
@ -- Hetero Robust F-Test -- @
 if rows(x1) .== 1;
  x=x2;
 else;
  x=x1~x2;
 endif;
 xxi=invpd(x'x);
 beta=xxi*(x'y);
 e1=y-x*beta;
 xre=x.*e1;
 vbeta=xxi*(xre'xre)*xxi;
 if rows(x1) ./= 1;
  beta=beta[cols(x1)+1:rows(beta)];
  vbeta=vbeta[cols(x1)+1:rows(vbeta),cols(x1)+1:cols(vbeta)];
 endif;
 fstat=beta'*(invpd(vbeta))*beta/rows(beta);
 signif=cdffc(fstat,cols(x2),rows(y)-cols(x));
endif;

retp(fstat,signif);
endp;
