proc(1) = modsel(yy,xy,xx,nobs,llmethod);

@ -- Procedure for model selection using moment regression moment matrices
     yy=y'y
     xy=x'y
     xx=x'x
     nobs=number of obs

     Cols of X are the choice variable (ordered)
     llmethod = Method   2 => nlag=aic(maxlag,minlag)
                         3 => nlag=bic(maxlag,minlag)
@
local crit, i, sse, morder,xxi;

if (llmethod ./=2) .and (llmethod ./=3);
  "llmethod is wrong in modsel.prc; returning maximum";
  retp(rows(xx));
endif;
crit=zeros(rows(xx),1);
i=1; do while i <= rows(xx);
  if i .== 1;
    xxi=1/xx[1,1];
  else;
    xxi=partinv(xxi,xx[1:i-1,i],xx[i,i]);
  endif;
  sse=yy-(xy[1:i,.])'*xxi*(xy[1:i,.]);
  if llmethod .== 2;
    crit[i]=ln(sse)+i*2/nobs;  @ AIC @
  endif;
  if llmethod .== 3;
   crit[i]=ln(sse)+i*ln(nobs)/nobs;  @ BIC @
  endif;
i=i+1; endo;
morder=minindc(crit);
retp(morder);
endp;

proc(1) = partinv(x11i,x12,x22);
 local f,e,y11,y12,xxi;
 f=x11i*x12;
 e=invpd(x22-x12'*f);
 y11=x11i+f*e*f';
 y12=-f*e;
 xxi=(y11~y12)|(y12'~e);
 retp(xxi);
 endp;

