@ tvpkilft.prc, 12/21/92, mww
  This is the kalman Filter for the model:

  y(t) = x(t)'b(t) + e(t)  (Scalar)
  b(t) = b(t-1) + a(t)     (vector)

  where var(e)=r and var(a)=q;

  Input:  y(t)
          x(t)
          b1 = b(t-1/t-1)
          p1 = p(t-1/t-1)
          r
          q

  output: b1 = b(t/t)
          p1 = p(t/t)

@
proc(2) = tvpkfilt(y,x,b1,p1,r,q);
local b2, p2, k, h, n, sby;

 b2=b1;
 p2=p1+q;
 n=y-x'b2;
 sby=p2*x;
 h=sby'x+r;
 k=sby/h;
 b1=b2+k*n;
 p1=p2-k*sby';

retp(b1,p1);
endp;

