/*
 TVPTST.PRC         JHS, MWW  12/18/92, Schow modified mww 1/10/95

 Procs which perform various break-point tests
*/
@----------- fsig.prc   JHS 12/18/92 --------------------------
   prints out significance *'s of f statistic
@
proc (1) = fsig(f,q,df);
 local pval,ss;
  pval=cdffc(f,q,df);
  if pval > .10                    ; ss="    ";
  elseif (pval>.05) and (pval<=.10); ss="*   ";
  elseif (pval>.01) and (pval<=.05); ss="**  ";
  elseif                (pval<=.01); ss="*** ";
  endif;
retp(ss);
endp;
@ ------------------------------------------------------@
@ lsig -- significance *'s for nyblom statistic @
 @ Critical Values from nycv.gss; 20,000 replications with
   T=1000 @
 proc (1)=lsig(lstat,df);
 local lcv, ns, ss;
 let lcv[30,4]=
       1.0000000       0.74728929       0.46324610       0.34672495
       2.0000000        1.0862049       0.74799777       0.60789146
       3.0000000        1.3859712        1.0011640       0.85039908
       4.0000000        1.6282653        1.2307952        1.0611609
       5.0000000        1.8689466        1.4643505        1.2770524
       6.0000000        2.0956795        1.6952364        1.4828462
       7.0000000        2.3383394        1.9048911        1.6991599
       8.0000000        2.5669129        2.1075561        1.8992056
       9.0000000        2.8204847        2.3234040        2.1026780
       10.000000        3.0348343        2.5350212        2.3053346
       11.000000        3.2497427        2.7443080        2.4963214
       12.000000        3.4846260        2.9538394        2.6960941
       13.000000        3.6948149        3.1543999        2.8980156
       14.000000        3.9035281        3.3592723        3.0889553
       15.000000        4.1261928        3.5551870        3.2773771
       16.000000        4.3420775        3.7470461        3.4720511
       17.000000        4.5597001        3.9489860        3.6548261
       18.000000        4.7722521        4.1509876        3.8515244
       19.000000        4.9619154        4.3371391        4.0348789
       20.000000        5.1649297        4.5362093        4.2266802
       21.000000        5.4082526        4.7359172        4.4214883
       22.000000        5.6021722        4.9304748        4.6149677
       23.000000        5.8043053        5.1174075        4.7930502
       24.000000        6.0053729        5.3040310        4.9872347
       25.000000        6.1784794        5.4982696        5.1667857
       26.000000        6.3764631        5.7001794        5.3500955
       27.000000        6.5502054        5.8909896        5.5399695
       28.000000        6.7553906        6.0678074        5.7211647
       29.000000        6.9873586        6.2615664        5.9146277
       30.000000        7.1862908        6.4594218        6.1034705 ;

 lcv=lcv[.,2:4];
 if df<=30;
  ns=sumc((lstat.>lcv[df,.])');
  if ns==0;     ss="    ";
  elseif ns==1; ss="*   ";
  elseif ns==2; ss="**  ";
  elseif ns==3; ss="*** ";
  endif;
 else; ss=" NA ";
 endif;
retp(ss);
endp;
@ ---------------------------------------------------------------- @
@ nyblom1.prc
 computes Nyblom's "L" test for martingale parameters
 JHS 7/26/91, minor modification 9/9/92
@
proc (2)=nyblom1(y,x1,x2,robust);
 local yy, zz, k, mzinv, e, seesq, ex, exs, v, lm9, lm, signif;
 if rows(x1)==1;
  yy=y; zz=x2; k=cols(x2);
 else;
  yy=y-x1*(invpd(x1'x1)*(x1'y));
  zz=x2-x1*(invpd(x1'x1)*(x1'x2));
  k=cols(x1)+cols(x2);
 endif;
 mzinv=invpd(zz'zz);
 e=yy-zz*(mzinv*(zz'yy)); seesq=(e'e)/(rows(e)-k);
 ex=zz.*e; exs=cumsumc(ex);
 if robust==1; v=ex'ex;
  else; v=seesq*(zz'zz); endif;
 lm9=(invpd(v)*(exs'exs))/rows(e);
 lm=sumc(diag(lm9));
 signif=lsig(lm,cols(x2));
retp(lm,signif);
endp;
@---------------------------------------------------------------------------@
@ kraplo1.prc    JHS 10/16/92 (Modified by MWW 12/9.92)
  Kramer-Ploberger full-sample residual test
@
proc (2)=kraplo1(y,x);
 local ehat, vcv, t1, m1, sig1, t2, m2, sig2;
 ehat=y - x*inv(x'x)*(x'y);
 vcv=ehat'ehat/(rows(y)-cols(x));
 t1=cumsumc(ehat/sqrt(rows(ehat)*vcv)); m1=maxc(abs(t1));
  if     m1>1.59;              sig1="***";
  elseif m1>1.31 and m1<=1.59;              sig1="**  ";
  elseif m1>1.19 and m1<=1.31; sig1="*   ";
  else;                        sig1="    "; endif;
 t2=t1.*t1; m2=meanc(t2);
  if     m2>.731;                sig2="***";
  elseif m2>0.450 and m2<=0.731;               sig2="**  ";
  elseif m2>0.339 and m2<=0.450; sig2="*   ";
  else;                          sig2="    "; endif;
 retp(m1|m2,sig1|sig2);
endp;
@---------------------------------------------------------------------------@
@ schow1.prc    mww, 12/17/92     modified JHS 12/18/92, mww 1/10/95
  Sequential Chow-tests for breaks.  Three tests constructed
  (1) Quandt LR = SUP(F)
  (2) Mean (F)
  (3) Andrews-Ploberger = ln of mean of (exp(F))
   Input:
   y = lhv data
   x1 = rhv data with fixed coefficients under null and alternative
   x2 = rhv data with fixed coefficients under null and
        time varying coefficients under alternative
   ccut=endpoints for sequential chow regressions
   nfchow=observation for returning fixed-date chow test (LR test)
   method =  indicator variable for method of carrying out test:
             (1) Wald form of test assuming homosk. errors
             (2) LR form of test assuming homosk. errors
             (3) LM form of test assuming hetero. errors
                 (Uses full sample avg. Moment Matrix)
             (4) Wald form of test assuming hetero. errors
                 (Uses actual Moment Matrix)
    Output:
    suplr  = sup(f)
    meanlr = mean(f)
    aplr   = andrews/ploberger statistic
    suplrs  = sign. string (*=10%), (**=5%), (***=1%)
    meanlrs = sign. string (*=10%), (**=5%), (***=1%)
    aplrs   = sign. string (*=10%), (**=5%), (***=1%)
   maxobs  = observation number corresponding to suplr
@
proc(5)=schow1(y,x1,x2,ccut,nfchow,method);
 local nobs, n1t, n2t, ktrim, sxy, e0, ss0, i, sxx, syy,
       sx2y, sxx2, sx2x2, ssb, lr, mxx, mxy,
       suplr, meanlr, aplr, ssuplr, smeanlr, saplr, lra, bb, maxobs,
       fchow, fcsig, sxx2i, x2t, x2ta, kap, mxxi, beta, w, e1, we,
       wewe, vbeta, x;

 nobs=rows(y); ktrim=floor(ccut*nobs); n1t=ktrim; n2t=nobs-ktrim;
 x=x2; if rows(x1) ./= 1; x=x1~x2; endif;
 @ full sample @
  sxy=x'y; sxx=x'x; syy=y'y;
  e0=y-x*(invpd(sxx))*sxy;
  ss0=e0'e0;

 @ Calculate Sequence of LR/Wald Statistics for Methods 1 or 2 @
 if (method .== 1) .or (method .== 2);
  @ subsample @
   ssb=zeros(nobs,1);
   sx2y=x2[1:n1t-1,.]'y[1:n1t-1,.];
   sx2x2=x2[1:n1t-1,.]'x2[1:n1t-1,.];
   sxx2=x[1:n1t-1,.]'x2[1:n1t-1,.];
   i=n1t; do until i>n2t;
   sx2y=sx2y+x2[i,.]'y[i,.];
   sx2x2=sx2x2+x2[i,.]'x2[i,.];
   sxx2=sxx2+x[i,.]'x2[i,.];
   mxx=(sxx~sxx2)|(sxx2'~sx2x2);
   mxy=sxy|sx2y;
   ssb[i,.]=syy-mxy'*(invpd(mxx))*mxy;
   i=i+1; endo;
  @ Wald form of test @
  if method .== 1;
    lr=(nobs-cols(mxx))*((ss0-ssb[n1t:n2t,.])./ssb[n1t:n2t,.]);
  endif;
  @ LR form of test @
  if method .== 2;
    lr=nobs*ln(1+((ss0-ssb[n1t:n2t,.])./ssb[n1t:n2t,.]));
  endif;
 endif;

 @ Calculate Statistics For LM-Hetero Robust Version of Test @
 if method .== 3;
   @ (1) Robust X2*e moment Matrix @
   x2t=x2.*e0;
   sxx2=x2t'x2t;
   sxx2i=invpd(sxx2);
   @ (2) Accumulate x2t as sequential score vector @
   x2ta=cumsumc(x2t);
   @ (3) Form Test Statistics Over n1t to n2t @
   lr=zeros(n2t-n1t+1,1);
   i=n1t; do until i>n2t;
    kap=i/nobs;
    lr[1+i-n1t]=x2ta[i,.]*sxx2i*x2ta[i,.]';
    lr[1+i-n1t]=lr[1+i-n1t]/(kap*(1-kap));
   i=i+1; endo;
 endif;

 @ Calculate Robust Wald Statistics for Methods 4 @
 if method .== 4;
   lr=zeros(n2t-n1t+1,1);
   sx2y=x2[1:n1t-1,.]'y[1:n1t-1,.];
   sx2x2=x2[1:n1t-1,.]'x2[1:n1t-1,.];
   sxx2=x[1:n1t-1,.]'x2[1:n1t-1,.];
   i=n1t; do until i>n2t;
    sx2y=sx2y+x2[i,.]'y[i,.];
    sx2x2=sx2x2+x2[i,.]'x2[i,.];
    sxx2=sxx2+x[i,.]'x2[i,.];
    mxx=(sxx~sxx2)|(sxx2'~sx2x2);
    mxy=sxy|sx2y;
    mxxi=invpd(mxx);
    beta=mxxi*mxy;
    w=x~(x2[1:i,.]|zeros(nobs-i,cols(x2)));
    e1=y-w*beta;
    we=w.*e1;
    wewe=we'we;
    vbeta=mxxi*(wewe)*mxxi;
    beta=beta[cols(x)+1:rows(beta),1];
    vbeta=vbeta[cols(x)+1:cols(vbeta),cols(x)+1:cols(vbeta)];
    lr[1+i-n1t]=beta'*invpd(vbeta)*beta;
   i=i+1; endo;
 endif;


 suplr=maxc(lr); maxobs=n1t+maxindc(lr)-1;
 meanlr=meanc(lr);
 aplr=ln(meanc(exp(0.5*lr)));
 ssuplr=suplrs(suplr,cols(x2));
 smeanlr=meanlrs(meanlr,cols(x2));
 saplr=aplrs(aplr,cols(x2));
 if nfchow>=n1t and nfchow<=n2t;
  fchow=lr[nfchow-n1t+1,.];
  fcsig=fsig(fchow/cols(x),cols(x),n2t-n1t+1-2*cols(x));
 else; fchow=0; fcsig="    ";endif;
retp((suplr~meanlr~aplr),(ssuplr~smeanlr~saplr),maxobs,fchow,fcsig);
endp;

@---------------------------------------------------------------------------@
@ schow2.prc    mww, 12/17/92     modified JHS 12/18/92, mww 2/3/95
  Sequential Chow-tests for breaks.  Three tests constructed
  (1) Quandt LR = SUP(F)
  (2) Mean (F)
  (3) Andrews-Ploberger = ln of mean of (exp(F))
   Input:
  (4)-(6) Hetero Robust Versions of these statistics using
          Method = 4 from schow1.prc
   y = lhv data
   x = rhv data
       (Note all variables are allowed to change under alternative)
   ccut=endpoints for sequential chow regressions
   nfchow=observation for returning fixed-date chow test (LR test)
    Output:
    suplr  = sup(f)
    meanlr = mean(f)
    aplr   = andrews/ploberger statistic
    suplrs  = sign. string (*=10%), (**=5%), (***=1%)
    meanlrs = sign. string (*=10%), (**=5%), (***=1%)
    aplrs   = sign. string (*=10%), (**=5%), (***=1%)
   maxobs  = observation number corresponding to suplr
@
proc(3)=schow2(y,x,ccut);

  local nobs, ktrim, n1t, n2t, xy, xx, yy, xxi, e0, ss0,
        x1y, x1x1, x1x1i, x2y, x2x2, x2x2i, b1, b2, e1,
        ssb, xe, v, lr, lr1, lr2, maxobs, suplr1, meanlr1, aplr1,
        suplr2, meanlr2, aplr2, i;

 nobs=rows(y); ktrim=floor(ccut*nobs); n1t=ktrim; n2t=nobs-ktrim;
 lr=zeros(n2t-n1t+1,2);
        @ full sample  Moment Matrices @
        xy=x'y;
        xx=x'x;
        yy=y'y;
        xxi=invpd(xx);
        e0=y-x*xxi*xy;
        ss0=e0'e0;
        x1y=x[1:n1t-1,.]'y[1:n1t-1,.];
        x1x1=x[1:n1t-1,.]'x[1:n1t-1,.];
       i=n1t; do until i> n2t;
         x1y=x1y+x[i,.]'y[i,.];
         x1x1=x1x1+x[i,.]'x[i,.];
         x2x2=xx-x1x1;
         x2y=xy-x1y;
         x1x1i=invpd(x1x1);
         x2x2i=invpd(x2x2);
         b2=x2x2i*x2y;
         b1=x1x1i*x1y;
         e1=y-( (x[1:i,.]*b1)|(x[i+1:rows(x),.]*b2) );
         ssb=e1'e1;
         lr[i-n1t+1,1]=(nobs-2*cols(x))*( (ss0-ssb)/ssb);
          @ -- Standard F-test -- @
         xe=x.*e1;
         v=x1x1i*(xe[1:i,.]'xe[1:i,.])*x1x1i
           + x2x2i*(xe[i+1:rows(xe),.]'xe[i+1:rows(xe),.])*x2x2i;
         lr[i-n1t+1,2]=(b1-b2)'invpd(v)*(b1-b2);
       i=i+1; endo;

  lr1=lr[.,1]; lr2=lr[.,2];
  @ -- Non Robust -- @
  suplr1=maxc(lr1); maxobs=n1t+maxindc(lr1)-1;
  meanlr1=meanc(lr1);
  aplr1=ln(meanc(exp(0.5*lr1)));

  @ -- Hetero Robust -- @
  suplr2=maxc(lr2);
  meanlr2=meanc(lr2);
  aplr2=ln(meanc(exp(0.5*lr2)));
retp((suplr1~meanlr1~aplr1),(suplr2~meanlr2~aplr2),maxobs);
endp;

@---------------------------------------------------------------------------@
@ schow3.prc    mww, 12/17/92     modified JHS 12/18/92, mww 2/7/95
  Sequential Chow-tests for breaks.  Three tests constructed
  (1) Quandt LR = SUP(F)
  (2) Mean (F)
  (3) Andrews-Ploberger = ln of mean of (exp(F))
   Input:
  (4)-(6) Hetero Robust Versions of these statistics using
          Method 8 (from Stock's Notes -- Like Method 4 in Schow
                     however, uses OLS Residuals )
   y = lhv data
   x = rhv data
       (Note all variables are allowed to change under alternative)
   ccut=endpoints for sequential chow regressions
   nfchow=observation for returning fixed-date chow test (LR test)
    Output:
    suplr  = sup(f)
    meanlr = mean(f)
    aplr   = andrews/ploberger statistic
    suplrs  = sign. string (*=10%), (**=5%), (***=1%)
    meanlrs = sign. string (*=10%), (**=5%), (***=1%)
    aplrs   = sign. string (*=10%), (**=5%), (***=1%)
   maxobs  = observation number corresponding to suplr
@
proc(3)=schow3(y,x,ccut);

  local nobs, ktrim, n1t, n2t, xy, xx, yy, xxi, e0, ss0,
        x1y, x1x1, x1x1i, x2y, x2x2, x2x2i, b1, b2, e1,
        ssb, xe, v, lr, lr1, lr2, maxobs, suplr1, meanlr1, aplr1,
        suplr2, meanlr2, aplr2, i, yy1, yy2, xxee, xxee1, xxee2;

 nobs=rows(y); ktrim=floor(ccut*nobs); n1t=ktrim; n2t=nobs-ktrim;
 lr=zeros(n2t-n1t+1,2);
        @ full sample  Moment Matrices @
        xy=x'y;
        xx=x'x;
        yy=y'y;
        xxi=invpd(xx);
        e0=y-x*xxi*xy;
        ss0=e0'e0;
        xe=x.*e0;
        xxee=xe'xe;
        x1y=x[1:n1t-1,.]'y[1:n1t-1,.];
        x1x1=x[1:n1t-1,.]'x[1:n1t-1,.];
        xxee1=xe[1:n1t-1,.]'xe[1:n1t-1,.];
        yy1=y[1:n1t-1,.]'y[1:n1t-1,.];
       i=n1t; do until i> n2t;
         x1y=x1y+x[i,.]'y[i,.];
         x1x1=x1x1+x[i,.]'x[i,.];
         xxee1=xxee1+xe[i,.]'xe[i,.];
         yy1=yy1+y[i,.]'y[i,.];
         x2x2=xx-x1x1;
         x2y=xy-x1y;
         yy2=yy-yy1;
         xxee2=xxee-xxee1;
         x1x1i=invpd(x1x1);
         x2x2i=invpd(x2x2);
         b1=x1x1i*x1y;
         b2=x2x2i*x2y;
         ssb=(yy1-x1y'b1) + (yy2-x2y'b2);
         lr[i-n1t+1,1]=(nobs-2*cols(x))*( (ss0-ssb)/ssb);
          @ -- Hetero- Rubust F-test -- @
         v=x1x1i*(xxee1)*x1x1i
           + x2x2i*(xxee2)*x2x2i;
         lr[i-n1t+1,2]=(b1-b2)'invpd(v)*(b1-b2);
       i=i+1; endo;

  lr1=lr[.,1]; lr2=lr[.,2];
  @ -- Non Robust -- @
  suplr1=maxc(lr1); maxobs=n1t+maxindc(lr1)-1;
  meanlr1=meanc(lr1);
  aplr1=ln(meanc(exp(0.5*lr1)));

  @ -- Hetero Robust -- @
  suplr2=maxc(lr2);
  meanlr2=meanc(lr2);
  aplr2=ln(meanc(exp(0.5*lr2)));
retp((suplr1~meanlr1~aplr1),(suplr2~meanlr2~aplr2),maxobs);
endp;

@---------------------------------------------------------------------------@
@ schow4.prc    mww, 12/17/92     modified JHS 12/18/92, mww 2/7/95
  Sequential Chow-tests for breaks.  Three tests constructed
  (1) Quandt LR = SUP(F)
  (2) Mean (F)
  (3) Andrews-Ploberger = ln of mean of (exp(F))
   Input:
  (4)-(6) Hetero Robust Versions of these statistics using
          Method 10 (from Stock's Notes -- Like Method 4 in Schow
                     however, uses OLS Residuals )
  (7)-(9) Hetero Robust Versions of these statistics using
          Method 9 (from Stock's Notes --  Method 4 in Schow)
   y = lhv data
   x = rhv data
       (Note all variables are allowed to change under alternative)
   ccut=endpoints for sequential chow regressions
   nfchow=observation for returning fixed-date chow test (LR test)
    Output:
    suplr  = sup(f)
    meanlr = mean(f)
    aplr   = andrews/ploberger statistic
    suplrs  = sign. string (*=10%), (**=5%), (***=1%)
    meanlrs = sign. string (*=10%), (**=5%), (***=1%)
    aplrs   = sign. string (*=10%), (**=5%), (***=1%)
   maxobs  = observation number corresponding to suplr
@
proc(4)=schow4(y,x,ccut);

  local nobs, ktrim, n1t, n2t, xy, xx, yy, xxi, e0, ss0,
        x1y, x1x1, x1x1i, x2y, x2x2, x2x2i, b1, b2, e1,
        ssb, xe, v, lr, lr1, lr2, lr3, maxobs, suplr1, meanlr1, aplr1,
        suplr2, meanlr2, aplr2, i, yy1, yy2, xxee, xxee1, xxee2,
        suplr3, meanlr3, aplr3, xe1;

 nobs=rows(y); ktrim=floor(ccut*nobs); n1t=ktrim; n2t=nobs-ktrim;
 lr=zeros(n2t-n1t+1,3);
        @ full sample  Moment Matrices @
        xy=x'y;
        xx=x'x;
        yy=y'y;
        xxi=invpd(xx);
        e0=y-x*xxi*xy;
        ss0=e0'e0;
        xe=x.*e0;
        xxee=xe'xe;
        x1y=x[1:n1t-1,.]'y[1:n1t-1,.];
        x1x1=x[1:n1t-1,.]'x[1:n1t-1,.];
        xxee1=xe[1:n1t-1,.]'xe[1:n1t-1,.];
        yy1=y[1:n1t-1,.]'y[1:n1t-1,.];
       i=n1t; do until i> n2t;
         x1y=x1y+x[i,.]'y[i,.];
         x1x1=x1x1+x[i,.]'x[i,.];
         xxee1=xxee1+xe[i,.]'xe[i,.];
         yy1=yy1+y[i,.]'y[i,.];
         x2x2=xx-x1x1;
         x2y=xy-x1y;
         yy2=yy-yy1;
         xxee2=xxee-xxee1;
         x1x1i=invpd(x1x1);
         x2x2i=invpd(x2x2);
         b1=x1x1i*x1y;
         b2=x2x2i*x2y;
         e1=y-( (x[1:i,.]*b1)|(x[i+1:rows(x),.]*b2) );
         ssb=e1'e1;
         lr[i-n1t+1,1]=(nobs-2*cols(x))*( (ss0-ssb)/ssb);
          @ -- Hetero- Rubust F-test -- @
         v=x1x1i*(xxee1)*x1x1i
           + x2x2i*(xxee2)*x2x2i;
         lr[i-n1t+1,2]=(b1-b2)'invpd(v)*(b1-b2);
         xe1=x.*e1;
         v=x1x1i*(xe1[1:i,.]'xe1[1:i,.])*x1x1i
           + x2x2i*(xe1[i+1:rows(xe1),.]'xe1[i+1:rows(xe1),.])*x2x2i;
         lr[i-n1t+1,3]=(b1-b2)'invpd(v)*(b1-b2);
       i=i+1; endo;

  lr1=lr[.,1]; lr2=lr[.,2]; lr3=lr[.,3];
  @ -- Non Robust -- @
  suplr1=maxc(lr1); maxobs=n1t+maxindc(lr1)-1;
  meanlr1=meanc(lr1);
  aplr1=ln(meanc(exp(0.5*lr1)));

  @ -- Hetero Robust Version 8 -- @
  suplr2=maxc(lr2);
  meanlr2=meanc(lr2);
  aplr2=ln(meanc(exp(0.5*lr2)));
  @ -- Hetero Robust Version 9 -- @
  suplr3=maxc(lr3);
  meanlr3=meanc(lr3);
  aplr3=ln(meanc(exp(0.5*lr3)));

retp((suplr1~meanlr1~aplr1),(suplr2~meanlr2~aplr2),
     (suplr3~meanlr3~aplr3),maxobs);
endp;

/* ---- Critical Values for Sup(Wald) -- Quandt LR ---- */
proc (1)=suplrs(suplr,df);
 @ Critical Values from Waldcv.gss; 20,000 replications with
   T=1000 @
 local lcv, ns, ss;
 let lcv[30,4]=
       1.0000000        12.013279        8.4637192        6.9436693
       2.0000000        14.942419        11.280271        9.6816337
       3.0000000        17.770146        13.677193        11.909054
       4.0000000        20.107834        15.936651        13.986995
       5.0000000        22.427926        17.928283        15.870902
       6.0000000        24.271502        19.708782        17.607145
       7.0000000        26.286494        21.568853        19.359869
       8.0000000        28.071983        23.136291        21.020557
       9.0000000        29.874222        24.953710        22.573412
       10.000000        31.502856        26.559235        24.163892
       11.000000        33.500995        28.205431        25.804817
       12.000000        35.196721        29.843885        27.386647
       13.000000        37.037909        31.485899        28.836606
       14.000000        38.434351        32.886096        30.292837
       15.000000        39.931364        34.479481        31.786785
       16.000000        41.788408        35.938845        33.351557
       17.000000        43.279328        37.461925        34.860811
       18.000000        44.947545        38.914715        36.121791
       19.000000        46.364783        40.462230        37.569985
       20.000000        48.020221        41.872616        38.896029
       21.000000        49.473572        43.351487        40.312474
       22.000000        50.998278        44.694130        41.700007
       23.000000        52.741166        46.164115        43.096885
       24.000000        54.189864        47.567423        44.474302
       25.000000        55.584065        48.981879        45.893410
       26.000000        56.954178        50.436926        47.286445
       27.000000        58.532396        51.857130        48.526579
       28.000000        59.731540        53.217524        49.983497
       29.000000        61.122082        54.505427        51.310738
       30.000000        62.455263        55.965693        52.651494   ;

lcv=lcv[.,2:4];
 if df<=30;
  ns=sumc((suplr.>lcv[df,.])');
  if ns==0;     ss="    ";
  elseif ns==1; ss="*   ";
  elseif ns==2; ss="**  ";
  elseif ns==3; ss="*** ";
  endif;
 else; ss=" NA ";
 endif;
retp(ss);
endp;


/* ---- Critical Values for mean(Wald) ------ */
proc (1)=meanlrs(meanlr,df);
 @ Critical Values from Waldcv.gss; 20,000 replications with
   T=1000 @
 local lcv, ns, ss;
 let lcv[30,4]=
       1.0000000        4.4474258        2.8005427        2.1550227
       2.0000000        6.2423616        4.4148718        3.6708830
       3.0000000        7.9545375        5.9319831        5.0642102
       4.0000000        9.5583894        7.2920539        6.3434549
       5.0000000        11.000057        8.7152872        7.6265982
       6.0000000        12.329349        9.9462423        8.8459478
       7.0000000        13.751325        11.314074        10.082716
       8.0000000        15.174642        12.525218        11.332240
       9.0000000        16.514136        13.866420        12.525018
       10.000000        17.776814        15.026599        13.696948
       11.000000        19.153236        16.241661        14.879775
       12.000000        20.538242        17.519614        16.050421
       13.000000        21.724739        18.700036        17.231985
       14.000000        22.931510        19.900665        18.350633
       15.000000        24.254419        21.074570        19.497003
       16.000000        25.522604        22.269522        20.656142
       17.000000        26.976327        23.415627        21.792486
       18.000000        28.098086        24.568380        22.921390
       19.000000        29.215237        25.814498        24.041589
       20.000000        30.622406        26.941690        25.201630
       21.000000        31.875082        28.113696        26.305260
       22.000000        32.986467        29.298965        27.374817
       23.000000        34.281419        30.458008        28.554015
       24.000000        35.447125        31.617658        29.674934
       25.000000        36.661773        32.747024        30.870818
       26.000000        38.050347        33.915577        31.921681
       27.000000        39.295891        34.982710        32.972261
       28.000000        40.503394        36.164225        34.088415
       29.000000        41.610817        37.255086        35.193677
       30.000000        42.710512        38.390232        36.267357 ;

 lcv=lcv[.,2:4];
 if df<=30;
  ns=sumc((meanlr.>lcv[df,.])');
  if ns==0;     ss="    ";
  elseif ns==1; ss="*   ";
  elseif ns==2; ss="**  ";
  elseif ns==3; ss="*** ";
  endif;
 else; ss=" NA ";
 endif;
retp(ss);
endp;

/* ---- Critical Values for APLR ------ */
proc (1)=aplrs(aplr,df);
 @ Critical Values from Waldcv.gss; 20,000 replications with
   T=1000 @
 local lcv, ns, ss;
 let lcv[30,4]=
       1.0000000        3.3702662        2.0825645        1.5214809
       2.0000000        4.7133870        3.1957925        2.5694679
       3.0000000        5.9291895        4.2159689        3.5180953
       4.0000000        7.0005386        5.1717993        4.3744661
       5.0000000        8.0151276        6.1017088        5.2185790
       6.0000000        8.9338584        6.8856146        6.0000552
       7.0000000        9.8388122        7.7250317        6.7924023
       8.0000000        10.674664        8.4987048        7.5475147
       9.0000000        11.626304        9.3230914        8.2738439
       10.000000        12.377833        10.085912        9.0027024
       11.000000        13.297673        10.862144        9.7635490
       12.000000        14.236013        11.608470        10.498656
       13.000000        14.980617        12.396164        11.182249
       14.000000        15.667030        13.079117        11.879306
       15.000000        16.463647        13.799313        12.607480
       16.000000        17.289870        14.554821        13.300210
       17.000000        18.086013        15.257102        14.008952
       18.000000        18.852224        15.965945        14.663064
       19.000000        19.526551        16.661294        15.309853
       20.000000        20.315070        17.357435        15.987619
       21.000000        20.880815        18.084732        16.659552
       22.000000        21.778745        18.689037        17.325180
       23.000000        22.521212        19.434685        17.994468
       24.000000        23.238137        20.118214        18.663235
       25.000000        23.959934        20.767116        19.340674
       26.000000        24.667764        21.471126        19.996951
       27.000000        25.379578        22.168279        20.637076
       28.000000        25.908951        22.860618        21.346422
       29.000000        26.655897        23.488931        21.968736
       30.000000        27.258662        24.194076        22.633316 ;
lcv=lcv[.,2:4];
 if df<=30;
  ns=sumc((aplr.>lcv[df,.])');
  if ns==0;     ss="    ";
  elseif ns==1; ss="*   ";
  elseif ns==2; ss="**  ";
  elseif ns==3; ss="*** ";
  endif;
 else; ss=" NA ";
 endif;
retp(ss);
endp;

@ ---------------------------------------------------------------- @
@ ---------------------------------------------------------------- @
@ BP.prc
 computes Breusch-Pagan LM test for Heteroskedasticity
@
proc (2)=BP(y,x1,x2);
 local x, e, n, r2, lm, signif;
 if rows(x1)==1;
  x=x2;
 else;
  x=x1~x2;
 endif;
 e=y-x*(inv(x'x))*(x'y);
 y=e.^2;
 x=(x2.^2);
 n=rows(y);
 y=y-meanc(y)';
 x=x-meanc(x)';
 r2=(y'x)*(inv(x'x))*(x'y)/(y'y);
 lm=n*r2;
 signif=cdfchic(lm,cols(x));
retp(lm,signif);
endp;
@---------------------------------------------------------------------------@
