proc(2)=udatain(sy,missc,tobs,ismpl);
/* udatain.prc, 5/24/94, mww
   This proc reads in data from file sy.
   It eliminates data in y when data is missing.
   Input:
         sy = string with file name for series y
         missc = missing value code
         tobs = total number of obs in series
         ismpl = vector of 1's and 0's representing SMPL statement
                 in calling program
   Output
          y = series y output
         ii = indicator of data locations;
*/
local y, iy, ii;
load y[tobs,1]=^sy;
iy = y .ne missc;
ii=iy.*ismpl;
y=selif(y,ii);

retp(y,ii);
endp;
