proc(1) = dlag2(x);
/*
   Procedure to calculate two-sided symmetric Inverse Fourier Transform
   for a given sequence.

   X = (n/2) x 1 complex valued vector
       corresponding to ordinated (2*j/n), j=1, ... n/2.
       (n is a power of 2).

   y = n x 1 inverse FFT of X, where
       X[0]=0  (thus eliminating any mean, i.e. sumc(y)=0)
       and x is padded (symmetrically to run from 0 to 2*)

   Note y is made into a "two-sided" filter:  That is using the y coeff.
   as the coefficient in A(L), where A(L) is a two-sided filter:

   A(0)=y(n/2); A[sub 1]=y( (n/2) + 1); A[sub -1]= = y( (n/2) - 1)
   Also y(1) = A[sub -(n/2)+1];  A[sub (n/2)-1] = y(n-1), 
   and y(n) = A[sub (n/2)]

*/
local y, nt2;

y=rev((x').');     @ Reverse of complex cojugate @
x=0|x|y[2:rows(y),.];
y=ffti(x);
nt2=rows(y)/2;
y=y[nt2+2:rows(y),1]|y[1:nt2+1,1];
y=real(y./rows(y));
retp(y);
endp;
