proc(1) = specdif(spec,w);
/* Transform Spectrum to Specrum of First Difference
         
    Input: Spec = Spectral Density Matrix
              w = required frequency

    Output: Specdif = spectral density matrix of first difference
*/
local im, z, az, a, specdif;

let im = 0+1i;
z=exp(-w*im);az=1-z;
a=az*eye(rows(spec));
specdif=a*spec*a';

retp(specdif);
endp;

