proc(1) = sptran(spec,w);
/* Transform Spectrum to Specrum of First Difference

   On input spec is the spectrum of
   y, y-c, y-i, n

   On output spec is spectrum of y, c, i, n
         
   w = required frequency

*/
local im, z, az, a ;

let im = 0+1i;
z=exp(-w*im);az=1-z;  @ az is first difference filter @
a=eye(rows(spec));
a[2,1]=1; a[2,2]=-az*a[2,2];
a[3,1]=1; a[3,3]=-az*a[3,3];
a[4,4]=az*a[4,4];
spec=a*spec*a';
retp(spec);
endp;

