proc(1) = spvar7(p1,p2,p3,p4,p5,p6,p7,seps,w);
/* Procedure for Calculating Spectral Density Matrix for a VAR6 of the
   form:
     s(t)=p1*s(t-1)+p2*s(t-2)+...+p6*s(t-6)+e(t)
     where var(e(t))=seps

   Output:  ss = spectrum of s at frequency w.
   Note: Spectrum is not divided by 2*pi

*/
local im, z, sm, smi, ss;
local z1, z2, z3, z4, z5, z6, z7;

@ -- Calculate Spectrum of S --- @
let im = 0+1i;
z=exp(-w*im);
z1=z;
z2=z1*z;
z3=z2*z;
z4=z3*z;
z5=z4*z;
z6=z5*z;
z7=z6*z;

sm=eye(rows(p1))-p1*z1-p2*z2-p3*z3-p4*z4-p5*z5-p6*z6-p7*z7;
smi=inv(sm);

ss=smi*seps*smi';
@ ss=ss/(2*pi);  @

retp(ss);
endp;
