proc(1) = sspec(m,g,h,w);
/* Procedure for Calculating Spectral Density Matrix for Variables
   in the State Space Model:

       s(t) = M s(t-1) + G e(t)
       v(t) = H s(t)

   where e(t) is iid(0,I).

   Input:  M
           G
           H
           w = required frequency

   Output:  SV = spectrum of V at frequency w.
   Note -- Spectrum is not normalized by 2*pi
*/
local im, z, sm, smi, smig, ss, sv;

@ -- Calculate Spectrum of S --- @
let im = 0+1i;
z=exp(-w*im);
sm=eye(rows(m))-m*z;
smi=inv(sm);
smig=smi*g;
ss=smig*smig';
@ ss=ss/(2*pi); @

@ -- Calculate Spectrum of V -- @
sv=h*ss*h';


retp(sv);
endp;

