% Summary Calculations -- Figures 1, 2, 3, 4, and 10
% May 17, 2015
%


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);
 
  % -- File Directories  
  outdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/out/';
  figdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/fig/';
  matdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/mat/';
  outfile_name = [outdir 'Table_4.out'];
  fileID = fopen(outfile_name,'w');
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  pcomp_data_calendar_mtoq;
  
  % Dates
  first_date = [1960 1];
  last_date = [2015 1];
  ismpl_60_end = smpl(calvec,first_date,last_date,4);
  cal_60_end = calvec(ismpl_60_end==1);
  dnobs_60_end = size(cal_60_end,1);
  
  dp_agg_60_end = dp_agg(ismpl_60_end==1,:);
  dp_agg_xe_60_end = dp_agg_xe(ismpl_60_end==1,:);
  dp_agg_xfe_60_end = dp_agg_xfe(ismpl_60_end==1,:);
  dp_disagg_60_end = dp_disagg(ismpl_60_end==1,:);
  share_avg_60_end = share_avg(ismpl_60_end==1,:);
  
  tmp = dp_agg;
  tmp1 = NaN*zeros(dnobs,1);
  tmp1(4:end) = (tmp(4:end)+tmp(3:end-1)+tmp(2:end-2)+tmp(1:end-3))/4;
  dp4_agg_60_end = tmp1(ismpl_60_end==1);
  
  tmp = dp_agg_xe;
  tmp1 = NaN*zeros(dnobs,1);
  tmp1(4:end) = (tmp(4:end)+tmp(3:end-1)+tmp(2:end-2)+tmp(1:end-3))/4;
  dp4_agg_xe_60_end = tmp1(ismpl_60_end==1);
  
  tmp = dp_agg_xfe;
  tmp1 = NaN*zeros(dnobs,1);
  tmp1(4:end) = (tmp(4:end)+tmp(3:end-1)+tmp(2:end-2)+tmp(1:end-3))/4;
  dp4_agg_xfe_60_end = tmp1(ismpl_60_end==1);
  
  tmp = dp_disagg;
  tmp1 = NaN*zeros(dnobs,17);
  tmp1(4:end,:) = (tmp(4:end,:)+tmp(3:end-1,:)+tmp(2:end-2,:)+tmp(1:end-3,:))/4;
  dp4_disagg_60_end = tmp1(ismpl_60_end==1,:);
  
  % -- Univariate Filtered and Smoothed Values
  ulabel = ['_PCEagg'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_h = tau_f_mean_pct(:,1);
  tau_s_h = tau_mean_pct(:,1);
  tau_f_mean_pct_h = tau_f_mean_pct;
  tau_s_mean_pct_h = tau_mean_pct;
  str_tmp = [matdir 'var_dtau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'vartotal_eps_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'var_eps_mean_pct' ulabel]; load(str_tmp);
  var_eps_mean_pct_h=var_eps_mean_pct;
  vartotal_eps_mean_pct_h=vartotal_eps_mean_pct;
  var_dtau_mean_pct_h = var_dtau_mean_pct;
  
  ulabel = ['_PCEagg_xe'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_xe = tau_f_mean_pct(:,1);
  tau_s_xe = tau_mean_pct(:,1);
  tau_f_mean_pct_xe = tau_f_mean_pct;
  tau_s_mean_pct_xe = tau_mean_pct;
  str_tmp = [matdir 'var_dtau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'vartotal_eps_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'var_eps_mean_pct' ulabel]; load(str_tmp);
  var_eps_mean_pct_xe=var_eps_mean_pct;
  vartotal_eps_mean_pct_xe=vartotal_eps_mean_pct;
  var_dtau_mean_pct_xe = var_dtau_mean_pct;
  
  ulabel = ['_PCEagg_xfe'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_xfe = tau_f_mean_pct(:,1);
  tau_s_xfe = tau_mean_pct(:,1);
  tau_f_mean_pct_xfe = tau_f_mean_pct;
  tau_s_mean_pct_xfe = tau_mean_pct;
  tau_f_mean_pct_xfe = tau_f_mean_pct;
  tau_s_mean_pct_xfe = tau_mean_pct;
  str_tmp = [matdir 'var_dtau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'vartotal_eps_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'var_eps_mean_pct' ulabel]; load(str_tmp);
  var_eps_mean_pct_xfe=var_eps_mean_pct;
  vartotal_eps_mean_pct_xfe=vartotal_eps_mean_pct;
  var_dtau_mean_pct_xfe = var_dtau_mean_pct;
  
  ulabel = ['_PCEagg_s0'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_s0_h = tau_f_mean_pct(:,1);
  tau_s_s0_h = tau_mean_pct(:,1);
  tau_f_mean_pct_s0_h = tau_f_mean_pct;
  tau_s_mean_pct_s0_h = tau_mean_pct;
  str_tmp = [matdir 'var_dtau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'vartotal_eps_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'var_eps_mean_pct' ulabel]; load(str_tmp);
  var_eps_mean_pct_s0_h=var_eps_mean_pct;
  vartotal_eps_mean_pct_s0_h=vartotal_eps_mean_pct;
  var_dtau_mean_pct_s0_h = var_dtau_mean_pct;
  
  % -- Some results for the 17-component model
  mlabel = '_mucsv_tvp_17c';
  str_tmp = [matdir 'agg_f_tau_mean_pct' mlabel]; load(str_tmp);
  str_tmp = [matdir 'agg_tau_mean_pct' mlabel]; load(str_tmp);
  tau_f_17c = agg_f_tau_mean_pct(:,1);
  tau_s_17c = agg_tau_mean_pct(:,1);
  tau_f_mean_pct_17c = agg_f_tau_mean_pct;
  tau_s_mean_pct_17c = agg_tau_mean_pct;
  
  % -- Some results for the 3-component model
  mlabel = '_mucsv_tvp_3c';
  str_tmp = [matdir 'agg_f_tau_mean_pct' mlabel]; load(str_tmp);
  str_tmp = [matdir 'agg_tau_mean_pct' mlabel]; load(str_tmp);
  tau_f_3c = agg_f_tau_mean_pct(:,1);
  tau_s_3c = agg_tau_mean_pct(:,1);
  tau_f_mean_pct_3c = agg_f_tau_mean_pct;
  tau_s_mean_pct_3c = agg_tau_mean_pct;
  
  % -- Figure 1 
  plot(cal_60_end,dp_agg_60_end,'- b','LineWidth',2);
  hold on;
   plot(cal_60_end,tau_s_h,'- b','LineWidth',4);
   plot(cal_60_end,tau_s_s0_h,'-- k','LineWidth',4);
  hold off;
  legend('Headline Inflation','UCSVO Trend','UCSV Trend');
  legend('Location','NorthEast');
  ax = gca;
  ax.FontSize = 35;
  ax.XLim = [1960 2015];
  %error('tmp');
  
  % -- Figure 2 
  plot(cal_60_end,dp_agg_60_end,'- b','LineWidth',2);
  hold on;
   plot(cal_60_end,tau_s_h,'- b','LineWidth',4);
   plot(cal_60_end,tau_s_xe,'-- k','LineWidth',4);
   plot(cal_60_end,tau_s_xfe,': r','LineWidth',4);
  hold off;
  legend('Headline Inflation','PCE-all Trend','PCExE Trend','PCExFE Trend');
  legend('Location','NorthEast');
  ax = gca;
  ax.FontSize = 35;
  ax.XLim = [1960 2015];
  %error('tmp');
  
  
% % -- Figure 3 -----
% figure;
% subplot(2,2,1);
%   plot(cal_60_end,sqrt(var_dtau_mean_pct_h(:,4)),'- b','LineWidth',3);
%   hold on;
%     plot(cal_60_end,sqrt(var_dtau_mean_pct_xe(:,4)),'-- k','LineWidth',3);
%     plot(cal_60_end,sqrt(var_dtau_mean_pct_xfe(:,4)),': r','LineWidth',3);  
%   hold off;
%   legend('PCE-all','PCExE','PCExFEE');
%   legend('Location','NorthEast');
% %   ylim([-10 15]);
%   titstr = '(a) \sigma_{\Delta\tau,{\itt}}';
%   title(titstr);
%   xlim([1955 2020]);
%   xlabel('Date'); 
%   ylabel('Percent'); 
%   ax = gca;
%   ax.FontSize = 30;
%   ax.XLim = [1960 2015];
% subplot(2,2,2);
%   plot(cal_60_end,sqrt(var_eps_mean_pct_h(:,4)),'- b','LineWidth',3);
%   hold on;
%     plot(cal_60_end,sqrt(var_eps_mean_pct_xe(:,4)),'-- k','LineWidth',3);
%     plot(cal_60_end,sqrt(var_eps_mean_pct_xfe(:,4)),': r','LineWidth',3);  
%   hold off;
% %   legend('PCE-all','PCExE','PCExFEE');
% %   legend('Location','NorthWest')
% %   ylim([-10 15]);
%   titstr = '(b) \sigma_{\epsilon,{\itt}}';
%   title(titstr);
%   xlim([1955 2020]);
%   xlabel('Date'); 
%   ylabel('Percent'); 
%   ax = gca;
%   ax.FontSize = 30;
%   ax.XLim = [1960 2015];
%  subplot(2,2,3);
%   plot(cal_60_end,sqrt(vartotal_eps_mean_pct_h(:,4)),'- b','LineWidth',3);
%   hold on;
%     plot(cal_60_end,sqrt(vartotal_eps_mean_pct_xe(:,4)),'-- k','LineWidth',3);
%     plot(cal_60_end,sqrt(vartotal_eps_mean_pct_xfe(:,4)),': r','LineWidth',3);  
%   hold off;
% %   legend('PCE-all','PCExE','PCExFEE');
% %   legend('Location','NorthWest');
% %   ylim([-10 15]);
%   titstr = '(c) \sigma_{\epsilon,{\itt}} \times {\its}_{{\itt}}';
%   title(titstr);
%   xlim([1955 2020]);
%   xlabel('Date'); 
%   ylabel('Percent'); 
%   ax = gca;
%   ax.FontSize = 30;
%   ax.XLim = [1960 2015];
%   
%   error('tmp');

% -------------- Figure 4 -----------
  plot(cal_60_end,dp_agg_60_end,'- b','LineWidth',1);
  hold on;
    plot(cal_60_end,dp_agg_xe_60_end,'-- k','LineWidth',3);  
    plot(cal_60_end,dp_agg_xfe_60_end,': r','LineWidth',3); 
    plot(cal_60_end,tau_s_17c,'- k','LineWidth',5);
    plot(cal_60_end,tau_s_h,'- b','LineWidth',3);  
  hold off;
  title('(a) 1960-2015');
  legend('PCE-all','PCExE','PCExFE','Multivariate Trend','Univariate Trend');
  legend('Location','NorthEast');
%   ylim([-10 15]);
  xlim([1955 2020]);
  xlabel('Date'); 
  ylabel('Percent'); 
  ax = gca;
  ax.FontSize = 30;
  ax.XLim = [1960 2015];
  
  %error('tmp');
  

 plot(cal_60_end,dp_agg_60_end,'- b','LineWidth',1);
 hold on;
    plot(cal_60_end,dp_agg_xe_60_end,'-- k','LineWidth',3);  
    plot(cal_60_end,dp_agg_xfe_60_end,': r','LineWidth',3); 
    plot(cal_60_end,tau_s_17c,'- k','LineWidth',5);
    plot(cal_60_end,tau_s_h,'- b','LineWidth',3);  
 hold off;
  title('(b) 2000-2015');
  xlim([1955 2020]);
  xlabel('Date'); 
  ylabel('Percent'); 
  ax = gca;
  ax.FontSize = 30;
  ax.XLim = [2000 2015];
  
  %error('tmp');
  
% ------- Figure 10 -------
   plot(cal_60_end,dp_agg_60_end,'- b','LineWidth',2);
   hold on;
     plot(cal_60_end,tau_s_17c,'-- k','LineWidth',4);
     plot(cal_60_end,tau_s_3c,': r','LineWidth',4);
   hold off;
   title('(a) Smoothed Trends')'
   legend('PCE-all','Trend 17-Components','Trend 3-Components');
   legend('Location','NorthEast'); 
   ax = gca;
   ax.FontSize = 30;
   ax.XLim = [1960 2015];
   %error('tmp');
   
   
   plot(cal_60_end,dp_agg_60_end,'- b','LineWidth',2);
   hold on;
     plot(cal_60_end,tau_f_17c,'-- k','LineWidth',4);
     plot(cal_60_end,tau_f_3c,': r','LineWidth',4);
   hold off;
   title('(b) Filtered Trends')'
%    legend('PCE-all','Trend 17-Components','Trend 3-Components');
%    legend('Location','NorthWest'); 
   ax = gca;
   ax.FontSize = 30;
   ax.XLim = [1960 2015];
 
  
  

  