% Summary Calculations 
% May 17, 2015
%


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);
 
  % -- File Directories  
  outdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/out/';
  figdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/fig/';
  matdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/mat/';
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  pcomp_data_calendar_mtoq;
  
  % Table 1: Shares
  ismpl1 = smpl(calvec,[1960 1],[2015 1],4);
  ismpl2 = smpl(calvec,[1960 1],[1979 4],4);
  ismpl3 = smpl(calvec,[1980 1],[1999 4],4);
  ismpl4 = smpl(calvec,[2000 1],[2015 1],4);
  ismpl = [ismpl1 ismpl2 ismpl3 ismpl4];
  tmp_mat = NaN*zeros(17,4);
  for i = 1:4;
      tmp = share_avg(ismpl(:,i)==1,:);
      tmp_mat(:,i) = (mean(tmp))';
  end;
  outfile_name = [outdir 'Table1_Shares.out'];
  fileID = fopen(outfile_name,'w');
  for i = 1:17;
      tmpstr = char(labelvec_disagg(i));
      fprintf(fileID,[tmpstr ',']);
      prtmat_comma(tmp_mat(i,:),fileID,'%5.3f','\n');
  end;
 