% Summary Calculations 
% May 17, 2015
%


clear all;
small = 1.0e-10;
big = 1.0e+6;                  
rng(63761);
 
  % -- File Directories  
  outdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/out/';
  figdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/fig/';
  matdir = '/Users/mwatson/Dropbox/p_comp/ddisk/matlab/mat/';
  outfile_name = [outdir 'Table_3.out'];
  fileID = fopen(outfile_name,'w');
  
  % -- Read in Data --- 
  load_data = 1;  % 1 if reloading data from Excel, etc 
  pcomp_data_calendar_mtoq;
  
  % Dates
  first_date = [1960 1];
  last_date = [2015 1];
  ismpl_60_end = smpl(calvec,first_date,last_date,4);
  cal_60_end = calvec(ismpl_60_end==1);
  dnobs_60_end = size(cal_60_end,1);
  
  dp_agg_60_end = dp_agg(ismpl_60_end==1,:);
  dp_agg_xe_60_end = dp_agg_xe(ismpl_60_end==1,:);
  dp_agg_xfe_60_end = dp_agg_xfe(ismpl_60_end==1,:);
  dp_disagg_60_end = dp_disagg(ismpl_60_end==1,:);
  share_avg_60_end = share_avg(ismpl_60_end==1,:);
  
  tmp = dp_agg;
  tmp1 = NaN*zeros(dnobs,1);
  tmp1(4:end) = (tmp(4:end)+tmp(3:end-1)+tmp(2:end-2)+tmp(1:end-3))/4;
  dp4_agg_60_end = tmp1(ismpl_60_end==1);
  
  tmp = dp_agg_xe;
  tmp1 = NaN*zeros(dnobs,1);
  tmp1(4:end) = (tmp(4:end)+tmp(3:end-1)+tmp(2:end-2)+tmp(1:end-3))/4;
  dp4_agg_xe_60_end = tmp1(ismpl_60_end==1);
  
  tmp = dp_agg_xfe;
  tmp1 = NaN*zeros(dnobs,1);
  tmp1(4:end) = (tmp(4:end)+tmp(3:end-1)+tmp(2:end-2)+tmp(1:end-3))/4;
  dp4_agg_xfe_60_end = tmp1(ismpl_60_end==1);
  
  tmp = dp_disagg;
  tmp1 = NaN*zeros(dnobs,17);
  tmp1(4:end,:) = (tmp(4:end,:)+tmp(3:end-1,:)+tmp(2:end-2,:)+tmp(1:end-3,:))/4;
  dp4_disagg_60_end = tmp1(ismpl_60_end==1,:);
  
  % -- Univariate Filtered and Smoothed Values
  ulabel = ['_PCEagg'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_h = tau_f_mean_pct(:,1);
  tau_s_h = tau_mean_pct(:,1);
  tau_f_mean_pct_h = tau_f_mean_pct;
  tau_s_mean_pct_h = tau_mean_pct;
  
  ulabel = ['_PCEagg_xe'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_xe = tau_f_mean_pct(:,1);
  tau_s_xe = tau_mean_pct(:,1);
  tau_f_mean_pct_xe = tau_f_mean_pct;
  tau_s_mean_pct_xe = tau_mean_pct;
  
  ulabel = ['_PCEagg_xfe'];
  str_tmp = [matdir 'tau_mean_pct' ulabel]; load(str_tmp);
  str_tmp = [matdir 'tau_f_mean_pct' ulabel]; load(str_tmp);
  tau_f_xfe = tau_f_mean_pct(:,1);
  tau_s_xfe = tau_mean_pct(:,1);tau_f_mean_pct_xfe = tau_f_mean_pct;
  tau_s_mean_pct_xfe = tau_mean_pct;
  tau_f_mean_pct_xfe = tau_f_mean_pct;
  tau_s_mean_pct_xfe = tau_mean_pct;
  
  % -- Some results for the 17-component model
  mlabel = '_mucsv_tvp_17c';
  str_tmp = [matdir 'agg_f_tau_mean_pct' mlabel]; load(str_tmp);
  str_tmp = [matdir 'agg_tau_mean_pct' mlabel]; load(str_tmp);
  tau_f_mean_pct_17c = agg_f_tau_mean_pct;
  tau_s_mean_pct_17c = agg_tau_mean_pct;
  
  tmp = [dp_agg_60_end tau_f_mean_pct_17c(:,3:5) tau_f_mean_pct_h(:,3:5) tau_f_mean_pct_xe(:,3:5) tau_f_mean_pct_xfe(:,3:5)];
  ismpl = smpl(cal_60_end,[2008 1],[2015 1],4);
  tmp = tmp(ismpl==1,:);
  prtmat_comma(tmp,fileID,'%6.2f','\n');
  
  
  

  