function drawplot(X,Y,the_title,the_ylim,varargin)

    %Plot of simulation data

    hold on;
    plot(X,Y);
    title(the_title,'FontSize',12);
    xlabel('T','FontSize',10);
    ylim(the_ylim);
    if isempty(varargin)==false; %If plot legend is provided as an argument...
        legend(varargin{1},'Location','SouthEast');
    end;
    set(gca,'YTick',linspace(the_ylim(1),the_ylim(2),5));
    set(gca,'FontSize',10);
    hold off;
end