function [F,y,eps,e,Lambda_0,lambda_star] = genvars(T,N,r,rho,a,sqrtOmega,R2_dom)

    %Generate simulated data

    u = randn(T,r); %Factor innovations
    f0 = randn(1,r)/sqrt(1-rho^2); %Initial values for factors
    F = filter(1,[1 -rho],[f0;u]); %AR(1)
    F = F(2:end,:);

    eps = randn(T-1,1); %Diffusion forecast error term
    y = F(1:end-1,:)*ones(r,1)+eps; %Forecast variable

    e_err = randn(T,N)*sqrtOmega'; %Innovations in AR(1) process for idiosyn. errors (called v in paper)
    e0 = randn(1,N)*sqrtOmega'/sqrt(1-a^2); %Starting distribution for idiosyn. term
    e = filter(1,[1 -a],[e0;e_err]); %AR(1)
    e = e(2:end,:);
    
    R2_i = (R2_dom(2)-R2_dom(1))*rand(N,1)+R2_dom(1); %Draw R-squares for initial common components
    lambda_star = @(x) sqrt((1-rho^2)/(r*(1-a^2))*x./(1-x)); %lambda^*(R^2)
    lambda_star_i = lambda_star(R2_i);
    Lambda_0_bar = randn(N,r);
    Lambda_0 = repmat(lambda_star_i,1,r).*Lambda_0_bar; %Initial loadings

end