%Plot results of Monte Carlo simulations as a function of T (execute run_mc.m first)

plot_m = 1; %Plot this index in the ms array
plot_k = 1; %1=plot with true rank imposed, 2=estimated rank
linestyles = {'-x','--x',':x','-.x'}; %List of line styles to cycle through

%Define plot legend
legend_wn = {'d=0','d=0.4','d=0.7'}; %White noise
legend_rw = {'c=0','c=2','c=3.5'}; %Random walk
legend_br = {'b=0','b=3.5','b=7'}; %Large break
% legend_wn = {'d=0','d=0.11','d=0.19'};
% legend_rw = {'c=0','c=0.53','c=0.93'};
% legend_br = {'b=0','b=0.25','b=0.50'};

%Extract plot data for each model
R2rat_plot_wn = reshape(R2rat_wn(:,plot_m,plot_k,:),length(Ts),length(ds));
S2rat_plot_wn = reshape(S2rat_wn(:,plot_m,plot_k,:),length(Ts),length(ds));

R2rat_plot_rw = reshape(R2rat_rw(:,plot_m,plot_k,:),length(Ts),length(cs));
S2rat_plot_rw = reshape(S2rat_rw(:,plot_m,plot_k,:),length(Ts),length(cs));
R2rat_plot_rw = [R2rat_plot_wn(:,1) R2rat_plot_rw]; %Append c=0 results
S2rat_plot_rw = [S2rat_plot_wn(:,1) S2rat_plot_rw]; %Append c=0 results

R2rat_plot_br = reshape(R2rat_br(:,plot_m,plot_k,:),length(Ts),length(bs));
S2rat_plot_br = reshape(S2rat_br(:,plot_m,plot_k,:),length(Ts),length(bs));
R2rat_plot_br = [R2rat_plot_wn(:,1) R2rat_plot_br]; %Append b=0 results
S2rat_plot_br = [S2rat_plot_wn(:,1) S2rat_plot_br]; %Append b=0 results

%Set plot colors and styles
set(0,'DefaultAxesColorOrder',zeros(1,3));
set(0,'DefaultAxesLineStyleOrder',linestyles);

if size(R2rat_plot_wn,2) > 0; %If there are white noise simulations to plot...
    f_wn = figure('Units','normalized','Position',[0.3 0 0.4 1]);
    subplot(2,1,1);
    drawplot(Ts,R2rat_plot_wn,'White noise model: Trace R^2',[0.8 1]);

    subplot(2,1,2);
    drawplot(Ts,S2rat_plot_wn,'White noise model: Closeness of forecast to infeasible one',[0.6 1],legend_wn);
end;

if size(R2rat_plot_rw,2) > 0; %If there are random walk simulations to plot...
    f_rw = figure('Units','normalized','Position',[0.3 0 0.4 1]);
    subplot(2,1,1);
    drawplot(Ts,R2rat_plot_rw,'Random walk model: Trace R^2',[0.8 1]);

    subplot(2,1,2);
    drawplot(Ts,S2rat_plot_rw,'Random walk model: Closeness of forecast to infeasible one',[0.6 1],legend_rw);
end;

if size(R2rat_plot_br,2) > 0; %If there are large break simulations to plot...
    f_br = figure('Units','normalized','Position',[0.3 0 0.4 1]);
    subplot(2,1,1);
    drawplot(Ts,R2rat_plot_br,'Large break model: Trace R^2',[0.8 1]);

    subplot(2,1,2);
    drawplot(Ts,S2rat_plot_br,'Large break model: Closeness of forecast to infeasible one',[0.6 1],legend_br);
end;