function [Fhat,Ftilde,Vk] = ppc(X,k)

    %Extract principal components from data

    [T,N] = size(X); %Data dimensions
    XX = X*X';
    [V,~] = eigs(XX,k); %Eigenvectors for k largest eigenvalues
    Ftilde=sqrt(T)*V;
    Fhat = XX*Ftilde/(N*T); %Principal components estimator
    
    Mhat = eye(T)-Fhat*(Fhat\eye(T)); %Annihilator matrix
    Vk = trace(X'*Mhat*X)/(N*T); %V(k)
    
end