function [R2s,S2s,khat] = summ_stats(F,Lambda_0,Lambda,y,e,max_rank)

    %Calculate summary statistics for simulated data

    %Read data dimensions
    [T,r] = size(F);
    N = size(Lambda_0,1);
    
    %Generate data
    X = zeros(T,N);
    for t = 1:T;
        X(t,:) = reshape(Lambda(t,:),N,r)*F(t,:)';
    end;
    X = X+e;

    if max_rank == 0; %If true rank should be imposed...
        Fhat = ppc(X,r);
    else %Otherwise, estimate rank...
        %Construct Bai-Ng (2002) information criterion
        g = log(min(N,T))*(N+T)/(N*T);
        ipc = inf;
        Fhat = [];
        for k=1:max_rank; %For each possible rank...
            [the_Fhat,~,the_Vk] = ppc(X,k); %Principal components estimate
            the_ipc = log(the_Vk)+k*g; %Information criterion value
            if the_ipc < ipc; %If IC value is smaller...
                Fhat = the_Fhat;
                ipc = the_ipc;
            end;
        end;
    end;
    
    khat = size(Fhat,2); %Rank estimate
    R2s = [norm(F*(F\Fhat),'fro'); norm(Fhat,'fro')].^2; %Numerator and denominator in trace R-square stat.
    
    zhat = Fhat(1:end-1,:); %Regressors in diffusion forecast
    deltahat = zhat\y; %Feasible estimated delta
    yhat = Fhat(end,:)*deltahat; %Feasible forecast
    deltatilde = F(1:end-1,:)\y; %Infeasible estimated delta
    ytilde = F(end,:)*deltatilde; %Infeasible forecast
    S2s = [yhat-ytilde; yhat].^2; %Numerator and denominator in fraction in formula for S-square stat.

end