clear;

%Generate LaTeX tables based on the simulation results

%Requires that simulation results are stored as filenames of the form:
%save/rhoXX_aYY_betaZZ.mat, where XX, YY and ZZ are numbers

%Also requires that the number of elements in the cs and bs arrays is 1 less than the length of the ds array

model = 'br'; %Model to generate table for
rhos = {'0','09'}; %Values of rho in filenames
as = {'0','05'}; %Values of a in filenames
betas = {'0','05'}; %Values of beta in filenames
TNcombs = [1 2; 1 3; 2 2; 2 3; 3 1; 3 2; 3 3]; %Combinations of T and N indices to print

disp(['*** Model = ' model]);
disp(' ');

for nrho=1:2; %For each rho...
    for nbeta=1:2; %For each beta...
        for na=1:2; %For each a...
            filename = ['save/rho' rhos{nrho} '_a' as{na} '_beta' betas{nbeta} '.mat']; %Simulation filename
            
            if exist(filename, 'file'); %If file exists...
            
                disp(['a = ' as{na} ', beta = ' betas{nbeta} ', rho = ' rhos{nrho}]); %Display parameters
                eval(['load ' filename]); %Load simulation data
                
                if ~strcmp(model,'wn'); %Append no-instability results
                    eval(['R2rat_' model ' = cat(4,R2rat_wn(:,:,:,1),R2rat_' model ');']);
                    eval(['S2rat_' model ' = cat(4,S2rat_wn(:,:,:,1),S2rat_' model ');']);
                    eval(['avgrank_' model ' = cat(4,avgrank_wn(:,:,:,1),avgrank_' model ');']);
                end;

                for ncomb=1:length(TNcombs); %For each (T,N) combination
                    nt = TNcombs(ncomb,1);
                    nm = TNcombs(ncomb,2);
                    fprintf('$%3d$ & $%3d$ ',Ts(nt),floor(Ts(nt)*ms(nm))); %Print (T,N)
                    for nd=1:length(ds); %For each d/c/b...
                        fprintf('& $%5.2f$ & $%5.2f$ & $%5.2f$ & $%5.2f$ & $%4.1f$ ',...
                            eval(['R2rat_' model '(nt,nm,1,nd)']),... %Trace R-square (k=r)
                            eval(['S2rat_' model '(nt,nm,1,nd)']),... %S-square (k=r)
                            eval(['R2rat_' model '(nt,nm,2,nd)']),... %Trace R-square (IC)
                            eval(['S2rat_' model '(nt,nm,2,nd)']),... %S-square (IC)
                            eval(['avgrank_' model '(nt,nm,2,nd)'])); %Avg. estimated rank (IC)
                    end;
                    fprintf('\\tabularnewline \n');
                end;
                disp(' ');
            
            end;
        end;
    end;
end;

clear;