proc(1) = gempr;
local n, var, t1, x, betat, res, betat1, betat2, x1, y;
local z1, z2, z3, z4, z5, z6, z7, z8;
/*
Generate Pseudo Post-War data by adding postwar residuals to Pre-war
trend (Plus initial conditions).
*/

@ Calculate Postwar residuals @
load path = d:\dr\data;
n=(90-46)*12;
load z1[n,1]=   lpmia.asc;
load z2[n,1]=   lpcc.asc;
load z3[n,1]=   lpem.asc;
load z4[n,1]=   lpt.asc;
load z5[n,1]=   lpfr.asc;
load z6[n,1]=   lptua.asc;
load z7[n,1]=   lps.asc;
load z8[n,1]=   lpgov.asc;
var=z1~z2~z3~z4~z5~z6~z7~z8;
y=ln(var);
t1=seqa(1,1,n);
x=ones(n,1)~t1;
betat=invpd(x'x)*x'y;
res=y-x*betat;
betat1=betat;
x1=x;

/* Estimate Prewar Trends */
n=7;
load z1[n,1]= kmi.prn;
load z2[n,1]= kcc.prn;
load z3[n,1]= kem.prn;
load z4[n,1]=  kt.prn;
load z5[n,1]= kfr.prn;
load z6[n,1]= ktu.prn;
load z7[n,1]=  ks.prn;
load z8[n,1]=kgov.prn;
var=z1~z2~z3~z4~z5~z6~z7~z8;
y=ln(var);
@ Detrend Data @
@ Trends:  1869-1929 @
t1=seqa(1,1,n);
x=ones(n,1)~(t1);
betat=invpd(x'x)*x'y;
betat2=betat;
betat2[2,.]=betat2[2,.]/120;   @ Convert dicennial trends to monthly trends @

"Post War constant ="; betat1[1,.];
"Post War trend =";    betat1[2,.];
"Pre War constant ="; betat2[1,.];
"Pre War trend =";    betat2[2,.];

@ Add Trends to Sochastic Components and Sum @
y=res+x1*betat2;
y=exp(y);
y=sumc(y');
retp(y);
endp;