proc(2) = enf1_2(bcp,bct,x);
/*
   Enforce 15 month P-P and T-T cycles.
   If Violated, choose highest peak and lowest trough
*/
local i, s, d1, d2, nv;

@ Skip this procedure if either bcpn or bctn contain missing values @
if (scalmiss(bcp) .== 1) .or (scalmiss(bct) .== 1);
 retp(bcp,bct);
endif;


"Enforcing minimum cycle length peak to peak...";
nv=0;
@ Check Peak to Peak @
i=2; do while i <= rows(bcp);
  if (bcp[i,1] - bcp[i-1,1]) .< 15;
   "  Two Peaks too close -- Eliminating peak at";;
   s=zeros(rows(bcp),1);
   d1=bcp[i-1,1]; d2=bcp[i,1];
   if x[d1,1] .> x[d2,1]; s[i,1]=1; cal[bcp[i,1],.];
   else;s[i-1,1]=1; cal[bcp[i-1,1],.]; endif;
   bcp=delif(bcp,s); nv=1;
   if (scalmiss(bcp) .== 1) .or (scalmiss(bct) .== 1);
     retp(bcp,bct); 
   endif;
   i=i-1;
  endif;
i=i+1; endo;
if nv==0; "  No violation of minimum peak to peak length found"; else;
{bcp,bct}=alter2(bcp,bct,x); endif; @ Impose Alternating P,T @

"Enforcing minimum cycle length trough to trough...";
nv=0;
@ Check Trough to Trough @
i=2; do while i <= rows(bct);
  if (bct[i,1] - bct[i-1,1]) .< 15;
   "  Two Troughs too close -- Eliminating trough at";;
   s=zeros(rows(bct),1);
   d1=bct[i-1,1]; d2=bct[i,1];
   if x[d1,1] .< x[d2,1]; s[i,1]=1; cal[bct[i,1],.];
   else;s[i-1,1]=1; cal[bct[i-1,1],.]; endif;
   bct=delif(bct,s); nv=1;
   if (scalmiss(bcp) .== 1) .or (scalmiss(bct) .== 1);
     retp(bcp,bct); 
   endif;
   i=i-1;
  endif;
i=i+1; endo;
if nv==0; "  No violation of minimum trough to trough length found"; else;
{bcp,bct}=alter2(bcp,bct,x); endif; @ Impose Alternating P,T @
retp(bcp,bct);
endp;
